/*
 * Decompiled with CFR 0.152.
 */
package online;

import g2d.Main;
import g2d.jlambda.Loader;
import g2d.pla.LauncherConfig;
import g2d.pla.PLA;
import g2d.util.ActorMsg;
import g2d.util.BrowserLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import online.AuthToken;
import online.HandShake;

public class NeoRemote {
    private final LauncherConfig config;

    public NeoRemote(String string) {
        if (string == null) {
            this.config = null;
            System.err.println("NeoRemote: url is null");
            return;
        }
        if (!PLA.setLauncherParameters((String)string)) {
            this.config = null;
            return;
        }
        this.config = PLA.config;
        Class<?> clazz = this.getClass();
        InputStream inputStream = Loader.getLisp(clazz, (String)this.config.lisp);
        try {
            Socket socket = new Socket(this.config.server, (int)this.config.port);
            this.launch(this.config.server, socket, inputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void main(String[] stringArray) {
        Main.setBinaryDirectory((String)".");
        if (stringArray.length != 1) {
            throw new RuntimeException("Wrong arguments to NeoRemote.main. Expecting just one, a url pointing to the configuration JSON.");
        }
        new NeoRemote(stringArray[0]);
    }

    private void authenticate(Socket socket, boolean bl) throws IOException {
        PrintStream printStream = new PrintStream(socket.getOutputStream());
        String string = new AuthToken(bl).toMsg();
        ActorMsg.sendActorMsg((OutputStream)printStream, (String)string);
    }

    private void launch(String string, Socket socket, InputStream inputStream) {
        HandShake handShake = new HandShake(socket, false);
        if (handShake.ready) {
            boolean bl = handShake.shake();
            if (bl) {
                Main.main((String)string, (InputStream)handShake.in, (PrintStream)handShake.out, (boolean)false, null, (InputStream)inputStream);
            } else if (handShake.response != null) {
                BrowserLauncher browserLauncher = new BrowserLauncher();
                browserLauncher.openURLinBrowser(handShake.response);
            } else {
                System.err.println("Something went wrong. Sorry.");
            }
        }
    }
}

