/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import java.util.ArrayList;
import java.util.Arrays;
import rmp.BitmaskHelper;
import rmp.Model;
import rmp.State;

public class Transition {
    private int[] preMask;
    private int[] postMask;
    private int[] readMask;
    private String name;

    public Transition(int[] nArray, int[] nArray2, int[] nArray3, String string) {
        this.preMask = nArray;
        this.postMask = nArray2;
        this.readMask = nArray3;
        this.name = string;
    }

    public void setReadMask(int[] nArray) {
        this.readMask = nArray;
    }

    public String getName() {
        return this.name;
    }

    public int getViolatingPreplace(Model model, State state) {
        int[] nArray = BitmaskHelper.OR(this.preMask, this.readMask);
        for (int i = 0; i < model.getSpeciesList().size(); ++i) {
            int[] nArray2 = BitmaskHelper.makeBitmask(new int[]{i}, model.getSpeciesList().size());
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, nArray), nArray2) || BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, state.getVars()), nArray2)) continue;
            return i;
        }
        return -1;
    }

    public int[] getPreMask() {
        return this.preMask;
    }

    public int[] getPostMask() {
        return this.postMask;
    }

    public int[] getReadMask() {
        return this.readMask;
    }

    public State applyTransition(State state) {
        if (!this.isEnabled(state)) {
            return null;
        }
        int[] nArray = state.getVars();
        nArray = BitmaskHelper.AND(BitmaskHelper.NOT(this.preMask), nArray);
        nArray = BitmaskHelper.OR(this.postMask, nArray);
        return new State(nArray);
    }

    public boolean isEnabled(State state) {
        int[] nArray = state.getVars();
        boolean bl = BitmaskHelper.EQUALS(BitmaskHelper.AND(this.preMask, nArray), this.preMask);
        if (!bl) {
            return false;
        }
        boolean bl2 = BitmaskHelper.EQUALS(BitmaskHelper.AND(this.postMask, BitmaskHelper.NOT(nArray)), this.postMask);
        if (!bl2) {
            return false;
        }
        boolean bl3 = BitmaskHelper.EQUALS(BitmaskHelper.AND(this.readMask, nArray), this.readMask);
        return bl3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(this.name);
        stringBuilder.append(" ");
        stringBuilder.append(Arrays.toString(this.preMask));
        stringBuilder.append(" ");
        stringBuilder.append(Arrays.toString(this.readMask));
        stringBuilder.append(" |- ");
        stringBuilder.append(Arrays.toString(this.postMask));
        return stringBuilder.toString();
    }

    public String toString(ArrayList<String> arrayList) {
        int n;
        int n2;
        int n3;
        String string = "Transition:  " + this.name;
        boolean bl = false;
        int[] nArray = this.preMask;
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (n2 <= 0) continue;
            bl = true;
        }
        if (bl) {
            string = string + "  Pre:  ";
            boolean bl2 = true;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                int[] nArray2 = BitmaskHelper.makeBitmask(new int[]{n4}, arrayList.size());
                if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(this.preMask, nArray2), nArray2)) continue;
                string = string + (bl2 ? "" : ",") + arrayList.get(n4);
                bl2 = false;
            }
        }
        boolean bl3 = false;
        int[] nArray3 = this.postMask;
        n3 = nArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray3[n2];
            if (n <= 0) continue;
            bl3 = true;
        }
        if (bl3) {
            string = string + "  Post:  ";
            boolean bl4 = true;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                int[] nArray4 = BitmaskHelper.makeBitmask(new int[]{n3}, arrayList.size());
                if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(this.postMask, nArray4), nArray4)) continue;
                string = string + (bl4 ? "" : ",") + arrayList.get(n3);
                bl4 = false;
            }
        }
        boolean bl5 = false;
        int[] nArray5 = this.readMask;
        int n5 = nArray5.length;
        for (n = 0; n < n5; ++n) {
            int n6 = nArray5[n];
            if (n6 <= 0) continue;
            bl5 = true;
        }
        if (bl5) {
            string = string + "  Read:  ";
            boolean bl6 = true;
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                int[] nArray6 = BitmaskHelper.makeBitmask(new int[]{n5}, arrayList.size());
                if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(this.readMask, nArray6), nArray6)) continue;
                string = string + (bl6 ? "" : ",") + arrayList.get(n5);
                bl6 = false;
            }
        }
        return string;
    }
}

