/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import java.util.ArrayList;
import rmp.BitmaskHelper;
import rmp.Model;
import rmp.Path;
import rmp.PathList;
import rmp.PlacePair;
import rmp.Transition;
import rmp.TransitionList;
import rmp.TransitionPair;

public class PathListOperations {
    public static ArrayList<String> essentialTransitions(Model model, PathList pathList) {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < pathList.size(); ++i) {
            ArrayList<String> arrayList2 = pathList.get(i).getTransitionNames(model.getTransitions());
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.addAll(arrayList2);
                continue;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string : arrayList) {
                if (!arrayList2.contains(string)) continue;
                arrayList3.add(string);
            }
            arrayList = arrayList3;
        }
        return arrayList;
    }

    public static ArrayList<TransitionPair> essentialTransitionPairs(Model model, PathList pathList) {
        ArrayList<String> arrayList = PathListOperations.essentialTransitions(model, pathList);
        TransitionList transitionList = model.getTransitions();
        ArrayList<TransitionPair> arrayList2 = new ArrayList<TransitionPair>();
        for (int i = 0; i < transitionList.size(); ++i) {
            for (int j = i + 1; j < transitionList.size(); ++j) {
                Transition transition = (Transition)transitionList.get(i);
                Transition transition2 = (Transition)transitionList.get(j);
                boolean bl = true;
                for (int k = 0; k < pathList.size(); ++k) {
                    Path path = pathList.get(k);
                    bl = bl && (path.getTransitionNames(transitionList).contains(transition.getName()) || path.getTransitionNames(transitionList).contains(transition2.getName()));
                }
                if (arrayList.contains(transition.getName()) || arrayList.contains(transition2.getName()) || !bl) continue;
                arrayList2.add(new TransitionPair(transition.getName(), transition2.getName()));
            }
        }
        return arrayList2;
    }

    /*
     * Could not resolve type clashes
     */
    public static ArrayList<String> knockouts(Model model, PathList pathList) {
        ArrayList<String> arrayList = model.getSpeciesList();
        ArrayList<String> arrayList2 = null;
        for (int i = 0; i < pathList.size(); ++i) {
            Object object2;
            ArrayList<String> arrayList32;
            ArrayList<Transition> arrayList4 = pathList.get(i).getTransitions(model.getTransitions());
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<String>();
                for (ArrayList<String> arrayList32 : arrayList4) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        int[] nArray = BitmaskHelper.makeBitmask(new int[]{j}, arrayList.size());
                        if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, ((Transition)((Object)arrayList32)).getPreMask()), nArray) && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, ((Transition)((Object)arrayList32)).getReadMask()), nArray) || arrayList2.contains(arrayList.get(j))) continue;
                        arrayList2.add(arrayList.get(j));
                    }
                }
                continue;
            }
            ArrayList arrayList5 = new ArrayList();
            for (Object object2 : arrayList4) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    int[] nArray = BitmaskHelper.makeBitmask(new int[]{j}, arrayList.size());
                    if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, ((Transition)object2).getPreMask()), nArray) && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, ((Transition)object2).getReadMask()), nArray) || arrayList5.contains(arrayList.get(j))) continue;
                    arrayList5.add(arrayList.get(j));
                }
            }
            arrayList32 = new ArrayList<String>();
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (!arrayList5.contains(string)) continue;
                arrayList32.add(string);
            }
            arrayList2 = arrayList32;
        }
        return arrayList2;
    }

    public static ArrayList<PlacePair> doubleKnockouts(Model model, PathList pathList) {
        ArrayList<PlacePair> arrayList = new ArrayList<PlacePair>();
        ArrayList<String> arrayList2 = PathListOperations.knockouts(model, pathList);
        ArrayList<String> arrayList3 = model.getSpeciesList();
        for (int i = 0; i < arrayList3.size(); ++i) {
            for (int j = i + 1; j < arrayList3.size(); ++j) {
                String string = arrayList3.get(i);
                String string2 = arrayList3.get(j);
                int[] nArray = BitmaskHelper.makeBitmask(new int[]{i}, arrayList3.size());
                int[] nArray2 = BitmaskHelper.makeBitmask(new int[]{j}, arrayList3.size());
                boolean bl = true;
                for (int k = 0; k < pathList.size(); ++k) {
                    Path path = pathList.get(k);
                    ArrayList<Transition> arrayList4 = path.getTransitions(model.getTransitions());
                    boolean bl2 = false;
                    for (Transition transition : arrayList4) {
                        bl2 = bl2 || BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getPreMask()), nArray) || BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getReadMask()), nArray);
                    }
                    boolean bl3 = false;
                    for (Transition transition : arrayList4) {
                        bl3 = bl3 || BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, transition.getPreMask()), nArray2) || BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, transition.getReadMask()), nArray2);
                    }
                    bl = bl && (bl2 || bl3);
                }
                if (arrayList2.contains(string) || arrayList2.contains(string2) || !bl) continue;
                arrayList.add(new PlacePair(string, string2));
            }
        }
        return arrayList;
    }

    public static ArrayList<String> usedPlaces(Model model, PathList pathList) {
        ArrayList<String> arrayList = model.getSpeciesList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < pathList.size(); ++i) {
            ArrayList<Transition> arrayList3 = pathList.get(i).getTransitions(model.getTransitions());
            for (Transition transition : arrayList3) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    int[] nArray = BitmaskHelper.makeBitmask(new int[]{j}, arrayList.size());
                    if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getPreMask()), nArray) && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getReadMask()), nArray) || arrayList2.contains(arrayList.get(j))) continue;
                    arrayList2.add(arrayList.get(j));
                }
            }
        }
        return arrayList2;
    }

    public static PathList pathsUsingPlace(Model model, PathList pathList, String string) {
        PathList pathList2 = new PathList();
        ArrayList<String> arrayList = model.getSpeciesList();
        int n = arrayList.indexOf(string);
        if (n != -1) {
            for (int i = 0; i < pathList.size(); ++i) {
                Path path = pathList.get(i);
                ArrayList<Transition> arrayList2 = path.getTransitions(model.getTransitions());
                boolean bl = false;
                for (Transition transition : arrayList2) {
                    int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, arrayList.size());
                    if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getPreMask()), nArray) && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getReadMask()), nArray)) continue;
                    bl = true;
                }
                if (!bl) continue;
                pathList2.addPath(path);
            }
        }
        return pathList2;
    }

    public static PathList pathsUsingPlaces(Model model, PathList pathList, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = model.getSpeciesList();
        PathList pathList2 = (PathList)pathList.clone();
        for (String string : arrayList) {
            PathList pathList3 = new PathList();
            int n = arrayList2.indexOf(string);
            if (n != -1) {
                int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, arrayList2.size());
                for (int i = 0; i < pathList2.size(); ++i) {
                    Path path = pathList2.get(i);
                    ArrayList<Transition> arrayList3 = path.getTransitions(model.getTransitions());
                    boolean bl = false;
                    for (Transition transition : arrayList3) {
                        if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getPreMask()), nArray) && !BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray, transition.getReadMask()), nArray)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    pathList3.addPath(path);
                }
            }
            pathList2 = pathList3;
        }
        return pathList2;
    }
}

