/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import java.util.ArrayList;
import java.util.Arrays;
import rmp.BitmaskHelper;
import rmp.State;
import rmp.Transition;
import rmp.TransitionList;

public class Model {
    private ArrayList<String> speciesList;
    private TransitionList transitions;
    private State initState;
    private int[] goalMask;

    public TransitionList getProperPretransitions(int n) {
        int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, this.speciesList.size());
        TransitionList transitionList = new TransitionList();
        for (int i = 0; i < this.transitions.size(); ++i) {
            int[] nArray2 = ((Transition)this.transitions.get(i)).getPostMask();
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, nArray), nArray)) continue;
            transitionList.add(this.transitions.get(i));
        }
        return transitionList;
    }

    public TransitionList getProperPosttransitions(int n) {
        int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, this.speciesList.size());
        TransitionList transitionList = new TransitionList();
        for (int i = 0; i < this.transitions.size(); ++i) {
            int[] nArray2 = ((Transition)this.transitions.get(i)).getPreMask();
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray2, nArray), nArray)) continue;
            transitionList.add(this.transitions.get(i));
        }
        return transitionList;
    }

    public TransitionList getPosttransitions(int n) {
        int[] nArray = BitmaskHelper.makeBitmask(new int[]{n}, this.speciesList.size());
        TransitionList transitionList = new TransitionList();
        for (int i = 0; i < this.transitions.size(); ++i) {
            int[] nArray2;
            int[] nArray3 = ((Transition)this.transitions.get(i)).getPreMask();
            int[] nArray4 = BitmaskHelper.OR(nArray3, nArray2 = ((Transition)this.transitions.get(i)).getReadMask());
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray4, nArray), nArray)) continue;
            transitionList.add(this.transitions.get(i));
        }
        return transitionList;
    }

    public State getInitialState() {
        return this.initState;
    }

    public TransitionList getTransitions() {
        return this.transitions;
    }

    public ArrayList<String> getSpeciesList() {
        return this.speciesList;
    }

    public Model(ArrayList<String> arrayList, TransitionList transitionList, State state, int[] nArray) {
        this.speciesList = arrayList;
        this.transitions = transitionList;
        this.initState = state;
        this.goalMask = nArray;
    }

    public int[] getGoalMask() {
        return this.goalMask;
    }

    public String speciesNamesToString() {
        String string = "";
        for (int i = 0; i < this.speciesList.size(); ++i) {
            string = string + (i == 0 ? "" : ",") + this.speciesList.get(i);
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.speciesNamesToString());
        stringBuilder.append("\n");
        stringBuilder.append(this.initState.toString(this.speciesList));
        stringBuilder.append("\n");
        stringBuilder.append(this.transitions.toString(this.speciesList));
        stringBuilder.append("\n");
        stringBuilder.append(this.initState.toString(this.speciesList));
        stringBuilder.append("\n");
        stringBuilder.append(Arrays.toString(this.goalMask));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

