/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import rmp.BitmaskHelper;
import rmp.Model;
import rmp.State;
import rmp.Transition;
import rmp.TransitionList;

public class ComputeStubbornSet {
    public static int countEnabledTransitions(Model model, State state, boolean[] blArray) {
        TransitionList transitionList = model.getTransitions();
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || !((Transition)transitionList.get(i)).isEnabled(state)) continue;
            ++n;
        }
        return n;
    }

    public static boolean[] computeSmallestStubbornSet(Model model, State state) {
        TransitionList transitionList = model.getTransitions();
        int n = -1;
        boolean[] blArray = null;
        for (int i = 0; i < transitionList.size(); ++i) {
            if (!((Transition)transitionList.get(i)).isEnabled(state)) continue;
            boolean[] blArray2 = ComputeStubbornSet.computeStubbornSet(model, state, i);
            int n2 = ComputeStubbornSet.countEnabledTransitions(model, state, blArray2);
            if (n2 == 1) {
                return blArray2;
            }
            if (n != -1 && n2 >= n) continue;
            blArray = blArray2;
            n = n2;
        }
        return blArray;
    }

    public static boolean[] computeStubbornSet(Model model, State state, int n) {
        boolean[] blArray = new boolean[model.getTransitions().size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        try {
            ComputeStubbornSet.computeStubbornSet(model, state, blArray, n);
        }
        catch (Exception exception) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
        }
        return blArray;
    }

    public static void computeStubbornSet(Model model, State state, boolean[] blArray, int n) throws Exception {
        block6: {
            TransitionList transitionList = model.getTransitions();
            if (blArray[n]) break block6;
            blArray[n] = true;
            if (((Transition)transitionList.get(n)).isEnabled(state)) {
                int[] nArray = ((Transition)transitionList.get(n)).getPreMask();
                int[] nArray2 = ((Transition)transitionList.get(n)).getReadMask();
                int[] nArray3 = BitmaskHelper.OR(nArray2, nArray);
                for (int i = 0; i < model.getSpeciesList().size(); ++i) {
                    int[] nArray4 = BitmaskHelper.makeBitmask(new int[]{i}, model.getSpeciesList().size());
                    if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray4, nArray3), nArray4)) continue;
                    TransitionList transitionList2 = model.getPosttransitions(i);
                    for (int j = 0; j < transitionList2.size(); ++j) {
                        int n2 = model.getTransitions().indexOf(transitionList2.get(j));
                        ComputeStubbornSet.computeStubbornSet(model, state, blArray, n2);
                    }
                }
            } else {
                int n3 = ((Transition)transitionList.get(n)).getViolatingPreplace(model, state);
                if (n3 == -1) {
                    throw new Exception();
                }
                TransitionList transitionList3 = model.getProperPretransitions(n3);
                for (int i = 0; i < transitionList3.size(); ++i) {
                    int n4 = model.getTransitions().indexOf(transitionList3.get(i));
                    ComputeStubbornSet.computeStubbornSet(model, state, blArray, n4);
                }
            }
        }
    }

    public static boolean[] computeStubbornSet(Model model, State state) {
        TransitionList transitionList = model.getTransitions();
        for (int i = 0; i < transitionList.size(); ++i) {
            if (!((Transition)transitionList.get(i)).isEnabled(state)) continue;
            return ComputeStubbornSet.computeStubbornSet(model, state, i);
        }
        return null;
    }
}

