/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtil {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    public static final TimeZone TIMEZONE_GERMANY = TimeZone.getTimeZone("Europe/Berlin");
    public static final SimpleDateFormat DF_GERMAN_DATE = new SimpleDateFormat("dd.MM.yyyy");
    public static final SimpleDateFormat DF_UK_DATE = new SimpleDateFormat("dd/MM/yyyy");
    public static final SimpleDateFormat DF_US_DATE = new SimpleDateFormat("MM/dd/yyyy");
    public static final SimpleDateFormat DF_GERMAN_DATE_TIME = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final String ZULU_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static DateUtil soleInstance = new DateUtil();

    public static DateUtil current() {
        return soleInstance;
    }

    protected DateUtil() {
    }

    public Date newDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return cal.getTime();
    }

    public Date newDate(TimeZone timezone, int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(year, month - 1, day);
        return cal.getTime();
    }

    public Date newDate(int year, int month, int day, int hour, int minute) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute);
        return cal.getTime();
    }

    public Date newDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        return cal.getTime();
    }

    public Date newGMTDate(int year, int month, int day, int hour, int minute, int second) {
        return this.newDate(TIMEZONE_GMT, year, month, day, hour, minute, second);
    }

    public Date newDate(TimeZone timezone, int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.set(year, month - 1, day, hour, minute, second);
        return cal.getTime();
    }

    public Date today() {
        return new Date();
    }

    public Calendar asCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public Calendar asCalendar(TimeZone timezone, Date date) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTime(date);
        return calendar;
    }

    public Calendar asGMTCalendar(Date date) {
        return this.asCalendar(TIMEZONE_GMT, date);
    }

    public String convertDateIntoZuluTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(ZULU_DATE_PATTERN);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.valueOf(format.format(date)) + "Z";
    }

    public Date convertZuluTimeIntoDate(String str) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(ZULU_DATE_PATTERN);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (str.endsWith("Z")) {
            str = str.substring(0, str.length() - 1);
        }
        return format.parse(str);
    }
}

