/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.pf.text.AStringFilter;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPatternCollection
extends AStringFilter {
    protected static final String DEFAULT_PATTERN_SEPARATOR = ";";
    private Collection<StringPattern> patterns = null;
    private Boolean ignoreCase = null;

    protected Collection<StringPattern> getPatterns() {
        return this.patterns;
    }

    protected void setPatterns(Collection<StringPattern> newValue) {
        this.patterns = newValue;
    }

    protected Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected void setIgnoreCase(Boolean newValue) {
        this.ignoreCase = newValue;
    }

    public static StringPatternCollection create(String patterns, boolean ignoreCase) {
        StringPatternCollection spc = new StringPatternCollection();
        spc.addPatterns(patterns);
        spc.setIgnoreCase(ignoreCase);
        return spc;
    }

    public static StringPatternCollection create(String[] patterns, boolean ignoreCase) {
        StringPatternCollection spc = new StringPatternCollection();
        spc.addPatterns(patterns);
        spc.setIgnoreCase(ignoreCase);
        return spc;
    }

    public StringPatternCollection() {
        this.reset();
    }

    public StringPatternCollection(String strPattern) {
        this();
        this.add(strPattern);
    }

    public StringPatternCollection(StringPattern pattern) {
        this();
        this.add(pattern);
    }

    public StringPatternCollection(String[] strPatterns) {
        this();
        this.addPatterns(strPatterns);
    }

    public StringPatternCollection(Collection strPatterns) {
        this();
        this.addPatterns(strPatterns);
    }

    @Override
    public boolean matches(String aString) {
        return this.matchesAny(aString);
    }

    public boolean matchesAny(String probe) {
        if (probe == null) {
            return false;
        }
        for (StringPattern pattern : this.getPatterns()) {
            if (!pattern.matches(probe)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesNone(String probe) {
        return !this.matchesAny(probe);
    }

    public boolean matchesAll(String probe) {
        if (probe == null) {
            return false;
        }
        for (StringPattern pattern : this.getPatterns()) {
            if (pattern.matches(probe)) continue;
            return false;
        }
        return true;
    }

    public String[] select(String[] strings) {
        return this.selectOrReject(strings, true);
    }

    public String[] reject(String[] strings) {
        return this.selectOrReject(strings, false);
    }

    public Collection select(Collection strings) {
        return this.selectOrReject(strings, true);
    }

    public Collection reject(Collection strings) {
        return this.selectOrReject(strings, false);
    }

    public void reset() {
        this.setPatterns(new ArrayList<StringPattern>());
        this.setIgnoreCase(null);
    }

    public void add(StringPattern aPattern) {
        if (aPattern != null && !this.getPatterns().contains(aPattern)) {
            if (this.getIgnoreCase() != null) {
                aPattern.setIgnoreCase(this.getIgnoreCase());
            }
            this.getPatterns().add(aPattern);
        }
    }

    public void addPatterns(String patternList) {
        this.addPatterns(patternList, DEFAULT_PATTERN_SEPARATOR);
    }

    public void addPatterns(String patternList, String separators) {
        if (patternList != null) {
            String[] strPatterns = this.str().substrings(patternList, separators);
            this.addPatterns(strPatterns);
        }
    }

    public void addPatterns(Collection<String> strPatterns) {
        if (strPatterns != null) {
            this.addPatterns(this.str().asStrings(strPatterns));
        }
    }

    public void addPatterns(StringPatternCollection patternCollection) {
        if (patternCollection != null) {
            for (StringPattern element : patternCollection.getPatterns()) {
                this.add(element);
            }
        }
    }

    public void addPatterns(String[] patternCollection) {
        if (patternCollection != null) {
            int i = 0;
            while (i < patternCollection.length) {
                this.add(patternCollection[i]);
                ++i;
            }
        }
    }

    public void add(String pattern) {
        if (pattern != null) {
            this.add(this.newPattern(pattern));
        }
    }

    public boolean remove(StringPattern aPattern) {
        boolean removed = false;
        if (aPattern != null) {
            removed = this.getPatterns().remove(aPattern);
        }
        return removed;
    }

    public int size() {
        return this.getPatterns().size();
    }

    public boolean isEmpty() {
        return this.getPatterns().isEmpty();
    }

    public String[] getPatternStrings() {
        if (this.isEmpty()) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[this.size()];
        Iterator<StringPattern> iter = this.getPatterns().iterator();
        int i = 0;
        while (i < result.length) {
            StringPattern pattern = iter.next();
            result[i] = pattern.getPattern();
            ++i;
        }
        return result;
    }

    public StringPatternCollection copy() {
        StringPatternCollection copy = new StringPatternCollection(this.getPatternStrings());
        copy.setIgnoreCase(this.getIgnoreCase());
        return copy;
    }

    public void setIgnoreCase(boolean ignore) {
        for (StringPattern pattern : this.getPatterns()) {
            pattern.setIgnoreCase(ignore);
        }
        this.setIgnoreCase(ignore ? Boolean.TRUE : Boolean.FALSE);
    }

    protected StringPattern newPattern(String pattern) {
        StringPattern strPattern = new StringPattern(pattern);
        strPattern.multiCharWildcardMatchesEmptyString(true);
        return strPattern;
    }

    protected String[] selectOrReject(String[] strings, boolean select) {
        if (strings == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            if (select == this.matchesAny(strings[i])) {
                result.add(strings[i]);
            }
            ++i;
        }
        return this.str().asStrings(result);
    }

    protected Collection selectOrReject(Collection strings, boolean select) {
        ArrayList<String> result;
        if (strings == null) {
            return null;
        }
        try {
            result = (ArrayList<String>)strings.getClass().newInstance();
        }
        catch (Exception e) {
            result = new ArrayList<String>(strings.size());
        }
        for (String str : strings) {
            if (select != this.matchesAny(str)) continue;
            result.add(str);
        }
        return result;
    }

    protected String getDefaultPatternSeparator() {
        return DEFAULT_PATTERN_SEPARATOR;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

