/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.bif.identifier.IObjectIdGenerator;
import org.pf.text.StringUtil;

public class ObjectIdGenerator
implements IObjectIdGenerator {
    protected static final char DEFAULT_PAD_CHAR = '0';
    protected static final long DEFAULT_START_ID = 1L;
    protected static final int DEFAULT_LENGTH = 10;
    private int length = 10;
    private char padChar = (char)48;
    private String prefix = null;
    private long nextAvailableId = 1L;
    protected int bufferLen = 10;

    protected long getNextAvailableId() {
        return this.nextAvailableId;
    }

    protected void setNextAvailableId(long newValue) {
        this.nextAvailableId = newValue;
    }

    public ObjectIdGenerator() {
        this.setLength(this.getDefaultLength());
        this.setNextAvailableId(this.getDefaultStartId());
        this.setPadChar(this.getDefaultPadChar());
    }

    public ObjectIdGenerator(int idLength) {
        this();
        this.setLength(idLength);
    }

    public ObjectIdGenerator(long startId, int idLength) {
        this(idLength);
        this.setNextAvailableId(startId);
    }

    public synchronized String newIdentifier() {
        return this.leftPad(this.nextIdentifier());
    }

    public long nextIdentifier() {
        long id = this.getNextId();
        this.setNextId(id + 1L);
        return id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int newValue) {
        if (newValue > 0) {
            this.length = newValue;
            this.calcBufferLength();
        }
    }

    public void setPadChar(char fillChar) {
        this.padChar = fillChar;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newValue) {
        this.prefix = newValue;
        this.calcBufferLength();
    }

    protected String leftPad(long id) {
        StringBuffer buffer = new StringBuffer(this.bufferLen);
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        this.str().leftPadCh(buffer, id, this.getLength(), this.getPadChar());
        return buffer.toString();
    }

    protected long getNextId() {
        return this.getNextAvailableId();
    }

    protected void setNextId(long id) {
        this.setNextAvailableId(id);
    }

    protected void calcBufferLength() {
        this.bufferLen = this.prefix == null ? this.getLength() : this.getLength() + this.prefix.length();
    }

    protected long getDefaultStartId() {
        return 1L;
    }

    protected int getDefaultLength() {
        return 10;
    }

    protected char getDefaultPadChar() {
        return '0';
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

