/*
 * Decompiled with CFR 0.152.
 */
package org.pf.swing;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.pf.swing.RadioButton;
import org.pf.swing.RadioButtonGroup;

public class RadioButtonGroupBox
extends JPanel
implements ActionListener {
    public static final int NEW_BUTTON_SET_ID = 1;
    public static final String NEW_BUTTON_SET_CMD = "radio.button.set";
    private RadioButtonGroup buttonGroup = null;
    private Collection actionListeners = null;

    protected void setButtonGroup(RadioButtonGroup newValue) {
        this.buttonGroup = newValue;
    }

    protected Collection getActionListeners() {
        return this.actionListeners;
    }

    protected void setActionListeners(Collection newValue) {
        this.actionListeners = newValue;
    }

    public RadioButtonGroupBox() {
        this(0);
    }

    public RadioButtonGroupBox(int axis) {
        this.setLayout(new BoxLayout(this, axis));
        this.setActionListeners(new HashSet());
        this.setButtonGroup(new RadioButtonGroup());
    }

    public RadioButtonGroupBox(LayoutManager layout) {
        this.setLayout(layout);
        this.setActionListeners(new HashSet());
        this.setButtonGroup(new RadioButtonGroup());
    }

    public RadioButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public Component add(RadioButton radioButton, int index) {
        this.registerButton(radioButton);
        return super.add((Component)radioButton, index);
    }

    public void add(RadioButton radioButton, Object constraints, int index) {
        this.registerButton(radioButton);
        super.add(radioButton, constraints, index);
    }

    public void add(RadioButton radioButton, Object constraints) {
        this.registerButton(radioButton);
        super.add((Component)radioButton, constraints);
    }

    public Component add(RadioButton radioButton) {
        this.registerButton(radioButton);
        return super.add(radioButton);
    }

    public Component add(String name, RadioButton radioButton) {
        this.registerButton(radioButton);
        return super.add(name, radioButton);
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.getActionListeners().add(listener);
        }
    }

    public void remove(RadioButton button) {
        this.deregisterButton(button);
        super.remove(button);
    }

    public void removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.getActionListeners().remove(listener);
        }
    }

    public Object getSelectedValue() {
        if (this.getButtonGroup() == null) {
            return null;
        }
        return this.getButtonGroup().getSelectedValue();
    }

    public void actionPerformed(ActionEvent event) {
        RadioButton button = (RadioButton)event.getSource();
        if (button.isSelected()) {
            this.notifyActionListeners();
        }
    }

    protected void notifyActionListeners() {
        ActionEvent event = new ActionEvent(this.getButtonGroup(), 1, NEW_BUTTON_SET_CMD);
        Iterator iter = this.getActionListeners().iterator();
        while (iter.hasNext()) {
            ActionListener listener = (ActionListener)iter.next();
            listener.actionPerformed(event);
        }
    }

    protected void registerButton(RadioButton button) {
        this.getButtonGroup().add(button);
        button.addActionListener(this);
    }

    protected void deregisterButton(RadioButton button) {
        button.removeActionListener(this);
        this.getButtonGroup().remove(button);
    }
}

