/*
 * Decompiled with CFR 0.152.
 */
package org.pf.reflect;

import java.util.List;
import org.pf.reflect.AttributeReadWriteAccess;
import org.pf.reflect.Dynamic;
import org.pf.reflect.ReflectUtil;

public class ObjectAccessWrapper
implements AttributeReadWriteAccess {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final ReflectUtil RU = ReflectUtil.current();
    private Object object;

    public ObjectAccessWrapper(Object object) {
        this.setObject(object);
    }

    public Object get(String fieldName) {
        String getterName = this.makeGetterName(fieldName);
        try {
            return Dynamic.perform(this.getObject(), getterName);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public void set(String fieldName, Object value) {
        String setterName = this.makeSetterName(fieldName);
        try {
            Dynamic.perform(this.getObject(), setterName, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Object getValueOfField(String fieldName) {
        try {
            return this.getAttributeValue(fieldName);
        }
        catch (NoSuchFieldException e) {
            this.handleException(e);
            return null;
        }
    }

    public void setValueOfField(String fieldName, Object value) {
        try {
            this.setAttributeValue(fieldName, value);
        }
        catch (NoSuchFieldException e) {
            this.handleException(e);
        }
    }

    public Object getAttributeValue(String name) throws NoSuchFieldException {
        return RU.getValueOf(this.getObject(), name);
    }

    public void setAttributeValue(String name, Object value) throws NoSuchFieldException {
        RU.setValueOf(this.getObject(), name, value);
    }

    public String[] getAttributeNames() {
        if (this.getObject() == null) {
            return EMPTY_STRING_ARRAY;
        }
        List fields = RU.getFieldsOf(this.getObject());
        if (fields == null) {
            return EMPTY_STRING_ARRAY;
        }
        return ReflectUtil.current().toStringArray(fields, "getName");
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    protected String makeGetterName(String fieldName) {
        return this.makeAccessMethodName("get", fieldName);
    }

    protected String makeSetterName(String fieldName) {
        return this.makeAccessMethodName("set", fieldName);
    }

    protected String makeAccessMethodName(String prefix, String fieldName) {
        StringBuffer methodName = new StringBuffer(fieldName.length() + prefix.length());
        methodName.append(prefix);
        methodName.append(fieldName.substring(0, 1).toUpperCase());
        methodName.append(fieldName.substring(1));
        return methodName.toString();
    }

    protected void handleException(Exception e) {
    }
}

