/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf.plugin.ClassRegistryException;
import org.pf.reflect.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRegistry<T> {
    private Class<T> entryType = null;
    private Map<Object, ClassInfo<T>> registry = null;

    protected Class<T> getEntryType() {
        return this.entryType;
    }

    protected void setEntryType(Class<T> newValue) {
        this.entryType = newValue;
    }

    protected Map<Object, ClassInfo<T>> registry() {
        return this.registry;
    }

    protected void registry(Map<Object, ClassInfo<T>> newValue) {
        this.registry = newValue;
    }

    public ClassRegistry() {
        this.registry(new HashMap<Object, ClassInfo<T>>());
    }

    public ClassRegistry(Class<T> typeOfRegisteredClasses) {
        this();
        this.setEntryType(typeOfRegisteredClasses);
    }

    public String getClassName(Object key) {
        ClassInfo<T> classInfo = this.get(key);
        return classInfo == null ? null : classInfo.getClassName();
    }

    public Class<T> getClass(Object key) {
        ClassInfo<T> classInfo = this.get(key);
        return classInfo == null ? null : classInfo.getClassObject();
    }

    public T newInstance(Object key) {
        ClassInfo<T> classInfo = this.get(key);
        return classInfo == null ? null : (T)classInfo.createInstance();
    }

    public boolean register(Object key, String className) {
        try {
            this.put(key, className);
            return true;
        }
        catch (ClassRegistryException ex) {
            return false;
        }
    }

    public void put(Object key, String className) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.assertArgNotNull("put", "className", className);
        ClassInfo classInfo = new ClassInfo(className);
        this.put(key, classInfo);
    }

    public boolean register(Object key, Class<T> aClass) {
        try {
            this.put(key, aClass);
            return true;
        }
        catch (ClassRegistryException ex) {
            return false;
        }
    }

    public void put(Object key, Class<T> aClass) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.assertArgNotNull("put", "aClass", aClass);
        ClassInfo classInfo = new ClassInfo(aClass);
        this.put(key, classInfo);
    }

    public boolean remove(Object key) {
        if (key != null) {
            ClassInfo<T> obj = this.registry().remove(key);
            return obj != null;
        }
        return false;
    }

    public String[] keys() {
        Set<Object> keys = this.registry().keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public ClassInfo[] values() {
        Collection<ClassInfo<ClassInfo>> values = this.registry().values();
        return values.toArray(new ClassInfo[values.size()]);
    }

    public Class[] classes() {
        List classes = this.collect(false);
        return classes.toArray(new Class[classes.size()]);
    }

    public String[] classNames() {
        List names = this.collect(true);
        return names.toArray(new String[names.size()]);
    }

    public ClassInfo<T> getClassInfo(String key) {
        return this.get(key);
    }

    protected ClassInfo<T> get(Object key) {
        if (key == null) {
            return null;
        }
        return this.registry().get(key);
    }

    protected void put(Object key, ClassInfo<T> classInfo) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.validate(classInfo);
        this.registry().put(key, classInfo);
    }

    protected void validate(ClassInfo<T> classInfo) throws ClassRegistryException {
        this.assertClassFound(classInfo);
        this.assertValidType(classInfo);
        this.assertInstanceCreation(classInfo);
    }

    protected void assertClassFound(ClassInfo<T> classInfo) throws ClassRegistryException {
        Class<T> aClass = classInfo.getClassObject();
        if (aClass == null) {
            throw new ClassRegistryException("Class " + classInfo.getClassName() + " not found");
        }
    }

    protected void assertValidType(ClassInfo classInfo) throws ClassRegistryException {
        if (this.isTyped() && !this.getEntryType().isAssignableFrom(classInfo.getClassObject())) {
            throw new ClassRegistryException("Class " + classInfo.getClassName() + " is not compatible to type " + this.getEntryType().getName());
        }
    }

    protected void assertInstanceCreation(ClassInfo classInfo) throws ClassRegistryException {
        try {
            classInfo.newInstance();
        }
        catch (Exception ex) {
            throw new ClassRegistryException("Unable to create instances of class " + classInfo.getClassName() + " (" + ex.getMessage() + ")");
        }
    }

    protected boolean isTyped() {
        return this.getEntryType() != null;
    }

    protected void assertArgNotNull(String methodName, String argName, Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument '" + argName + "' not valid in method '" + this.getClass().getName() + "." + methodName + "'");
        }
    }

    protected void illegalArgumentException(String methodName, String argName) {
        throw new IllegalArgumentException("Argument '" + argName + "' not valid in method '" + this.getClass().getName() + "." + methodName + "'");
    }

    protected List collect(boolean collectNames) {
        Collection<ClassInfo<T>> values = this.registry().values();
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (ClassInfo<T> classInfo : values) {
            if (collectNames) {
                result.add(classInfo.getClassName());
                continue;
            }
            result.add(classInfo.getClassObject());
        }
        return result;
    }
}

