/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.util.ArrayList;
import java.util.List;
import org.pf.file.DirectoryContents;
import org.pf.file.FileInfo;

public class TableOfContents {
    private String containerName = null;
    private List dirInfos = null;

    protected String getContainerName() {
        return this.containerName;
    }

    protected void setContainerName(String newValue) {
        this.containerName = newValue;
    }

    protected List getDirInfos() {
        return this.dirInfos;
    }

    protected void setDirInfos(List newValue) {
        this.dirInfos = newValue;
    }

    public TableOfContents(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        this.setContainerName(name);
        this.setDirInfos(new ArrayList());
    }

    public String getName() {
        return this.getContainerName();
    }

    public void add(DirectoryContents dir) {
        if (dir != null) {
            this.getDirInfos().add(dir);
        }
    }

    public DirectoryContents[] getDirectories() {
        DirectoryContents[] array = new DirectoryContents[this.getDirInfos().size()];
        this.getDirInfos().toArray(array);
        return array;
    }

    public int size() {
        return this.getDirInfos().size();
    }

    public DirectoryContents dirContentAt(int index) {
        return (DirectoryContents)this.getDirInfos().get(index);
    }

    public String dirNameAt(int index) {
        return this.dirContentAt(index).getDirName();
    }

    public FileInfo[] filesAt(int index) {
        return this.dirContentAt(index).getContainedFiles();
    }

    protected String inspectString() {
        return "TableOfContents(\"" + this.getName() + "\")";
    }
}

