/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pf.file.FileUtil;
import org.pf.file.LoggerProvider;
import org.pf.logging.Logger;
import org.pf.security.authentication.AutoAuthenticationManager;
import org.pf.text.StringFilter;
import org.pf.text.StringPatternCollection;
import org.pf.text.StringUtil;

public class FileLocator {
    private static final boolean DEBUG = "true".equals(System.getProperty("org.pf.file.FileLocator.debug"));
    private static final String ARCHIVE_INDICATOR = "!" + File.separator;
    private static final String JAR_INDICATOR = "jar:";
    private static final String HTTP_INDICATOR = "http://";
    private static final String HTTPS_INDICATOR = "https://";
    private static final String JAR_HTTP_INDICATOR = "jar:http://";
    private static final String JAR_HTTPS_INDICATOR = "jar:https://";
    private static final String[] SUPPORTED_REMOTE_PROTOCOLS = new String[]{"http://", "https://", "jar:http://", "jar:https://"};
    private static final StringFilter JAR_FILE_INDICATORS = new StringPatternCollection(new String[]{"jar:file:/*", "jar:file:\\*"});
    public static final String TEMP_FILE_PREFIX = "FLOC_";
    public static final String TEMP_FILE_SUFFIX = ".xtr";
    private FileLocator parentLocator = null;
    private File file = null;
    private ZipFile zipFile = null;
    private Boolean exists = Boolean.TRUE;
    private Exception exception = null;
    private String originalFileName = null;
    private boolean remote = false;

    protected FileLocator getParentLocator() {
        return this.parentLocator;
    }

    protected void setParentLocator(FileLocator newValue) {
        this.parentLocator = newValue;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File newValue) {
        this.file = newValue;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void setZipFile(ZipFile newValue) {
        this.zipFile = newValue;
    }

    protected Boolean getExists() {
        return this.exists;
    }

    protected void setExists(Boolean newValue) {
        this.exists = newValue;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception newValue) {
        this.exception = newValue;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    protected boolean getRemote() {
        return this.remote;
    }

    protected void setRemote(boolean newValue) {
        this.remote = newValue;
    }

    public static FileLocator create(File file) {
        FileLocator locator = new FileLocator(file.getPath(), false);
        return locator.createFrom(file);
    }

    public static FileLocator create(URL url) {
        return FileLocator.create(url.toString());
    }

    public static FileLocator create(String filename) {
        if (FileLocator.usesSupportedRemoteProtocol(filename)) {
            return new FileLocator(filename, true);
        }
        if (JAR_FILE_INDICATORS.matches(filename)) {
            return FileLocator.createFromJarFileUrl(filename);
        }
        return FileLocator.create(new File(filename));
    }

    private static FileLocator createFromJarFileUrl(String filename) {
        String simpleFilename = filename.substring(JAR_INDICATOR.length());
        simpleFilename = FileLocator.str().replaceAll(simpleFilename, ARCHIVE_INDICATOR, "/");
        FileLocator locator = FileLocator.create(new File(simpleFilename));
        locator.setOriginalFileName(filename);
        return locator;
    }

    private static FileLocator newWith(FileLocator aParent, String[] pathElements) throws Exception {
        FileLocator locator = new FileLocator();
        return locator.createFrom(aParent, pathElements);
    }

    protected static boolean usesSupportedRemoteProtocol(String filename) {
        if (filename == null) {
            return false;
        }
        int i = 0;
        while (i < SUPPORTED_REMOTE_PROTOCOLS.length) {
            if (filename.startsWith(SUPPORTED_REMOTE_PROTOCOLS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static StringUtil str() {
        return StringUtil.current();
    }

    protected static FileUtil fileUtil() {
        return FileUtil.current();
    }

    FileLocator() {
    }

    private FileLocator(String filename, boolean remoteFile) {
        this();
        this.setRemote(remoteFile);
        if (remoteFile) {
            this.setExists(null);
        }
        this.setOriginalFileName(filename);
    }

    public File realFile() {
        File aFile;
        if (!this.exists()) {
            return null;
        }
        try {
            aFile = this.fileRef();
        }
        catch (Exception e) {
            aFile = null;
        }
        return aFile;
    }

    public boolean exists() {
        if (this.isUnlocatedRemoteFile()) {
            this.copyFromRemote();
            if (this.getExists() == null) {
                return false;
            }
        }
        return this.getExists();
    }

    public boolean isFile() {
        try {
            if (this.exists()) {
                return this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            if (this.exists()) {
                return !this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRemote() {
        return this.getRemote();
    }

    public long size() {
        this.exists();
        try {
            if (this.isInArchive()) {
                ZipEntry entry = this.archiveEntry();
                return entry.getSize();
            }
            return this.getFile().length();
        }
        catch (Exception ex) {
            if (DEBUG) {
                this.logger().logException(ex);
            }
            return 0L;
        }
    }

    public long lastModified() {
        this.exists();
        try {
            if (this.isInArchive()) {
                ZipEntry entry = this.archiveEntry();
                return entry.getTime();
            }
            return this.getFile().lastModified();
        }
        catch (Exception ex) {
            if (DEBUG) {
                this.logger().logException(ex);
            }
            return 0L;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        if (this.isInArchive()) {
            ZipEntry entry = this.archiveEntry();
            return this.container().getInputStream(entry);
        }
        return new FileInputStream(this.getFile());
    }

    public FileLocator getParent() {
        String path = FileLocator.str().cutTail(this.getStandardizedAbsolutePath(), "/");
        return FileLocator.create(path);
    }

    public boolean isInArchive() {
        return this.getParentLocator() != null;
    }

    public String getPath() {
        return this.fullFilePath(false).getPath();
    }

    public String getAbsolutePath() {
        if (this.isRemote()) {
            return this.getOriginalFileName();
        }
        return this.fullFilePath(true).getPath();
    }

    public String getStandardizedPath() {
        return FileLocator.fileUtil().standardize(this.getPath());
    }

    public String getStandardizedAbsolutePath() {
        return FileLocator.fileUtil().standardize(this.getAbsolutePath());
    }

    public Exception exception() {
        return this.getException();
    }

    public URL toURL() throws MalformedURLException {
        StringBuffer buffer = new StringBuffer(128);
        this.urlPath(buffer);
        return new URL(buffer.toString());
    }

    public String toString() {
        return this.getStandardizedAbsolutePath();
    }

    protected FileLocator createFrom(File filePath) {
        FileLocator locator = null;
        String[] parts = null;
        File path = filePath;
        if (FileLocator.fileUtil().isLocalFileURL(path.getPath())) {
            path = this.convertFromURLSyntax(path);
        }
        parts = FileLocator.str().parts(path.getPath(), File.separator);
        try {
            locator = this.initFromPath(parts, path.getPath().startsWith(File.separator));
        }
        catch (Exception ex) {
            this.setException(ex);
            this.doesNotExist(path);
            locator = this;
        }
        return locator;
    }

    private FileLocator createFrom(FileLocator aParent, String[] pathElements) throws Exception {
        this.setParentLocator(aParent);
        return this.initFromPath(pathElements, false);
    }

    protected FileLocator initFromPath(String[] parts, boolean startsFromRoot) throws Exception {
        FileLocator locator = this;
        File pathElement = null;
        String[] rest = null;
        boolean elementExists = false;
        if (startsFromRoot) {
            pathElement = new File(File.separator);
        }
        int i = 0;
        while (i < parts.length) {
            elementExists = this.doesElementExist(pathElement = pathElement == null ? new File(parts[i]) : new File(pathElement, parts[i]));
            if (elementExists) {
                this.setFile(pathElement);
                if (this.isFileElement(pathElement)) {
                    if (DEBUG) {
                        this.logger().logDebug("Locator(" + pathElement + ")");
                    }
                    if (i >= parts.length - 1) break;
                    String originalName = this.getOriginalFileName();
                    this.setOriginalFileName(pathElement.getPath());
                    rest = FileLocator.str().copyFrom(parts, i + 1);
                    locator = FileLocator.newWith(this, rest);
                    locator.setOriginalFileName(originalName);
                    break;
                }
            } else if (this.isInArchive()) {
                if (i >= parts.length - 1) {
                    throw new Exception("\"" + pathElement.getPath() + "\" does not exist");
                }
            } else {
                throw new Exception("\"" + pathElement.getPath() + "\" does not exist");
            }
            ++i;
        }
        return locator;
    }

    protected boolean doesElementExist(File element) throws Exception {
        if (this.isInArchive()) {
            return this.doesElementExistInArchive(element.getPath());
        }
        return element.exists();
    }

    protected boolean isFileElement(File element) throws Exception {
        if (this.isInArchive()) {
            return this.isFileInArchive(element.getPath());
        }
        return element.isFile();
    }

    protected boolean doesElementExistInArchive(String elementName) throws Exception {
        ZipEntry entry = this.entryFromArchive(elementName);
        return entry != null;
    }

    protected boolean isFileInArchive(String elementName) throws Exception {
        ZipEntry entry = this.entryFromArchive(elementName);
        return entry != null && entry.getSize() > 0L;
    }

    protected ZipEntry entryFromArchive(String elementName) throws IOException {
        String name = FileLocator.str().replaceAll(elementName, "\\", "/");
        ZipFile archive = this.container();
        ZipEntry entry = archive.getEntry(name);
        if (DEBUG) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(String.valueOf(archive.getName()) + "::" + name + " --- " + (entry != null));
            if (entry == null) {
                buffer.append("\n");
            } else {
                buffer.append(" (" + entry.getSize() + ")");
                buffer.append(" (T:" + entry.getTime() + ")");
                buffer.append(" (" + (entry.isDirectory() ? "Dir" : "File") + ")\n");
            }
            this.logger().logDebug(buffer.toString());
        }
        return entry;
    }

    protected ZipEntry archiveEntry() throws IOException {
        return this.entryFromArchive(this.getFile().getPath());
    }

    protected void doesNotExist(File aFile) {
        this.setExists(Boolean.FALSE);
        this.setFile(aFile);
    }

    protected File fullFilePath(boolean absolute) {
        if (!this.exists() && this.isRemote()) {
            return null;
        }
        File full = this.isInArchive() ? new File(this.getParentLocator().fullFilePath(absolute), this.getFile().getPath()) : (absolute ? this.getFile().getAbsoluteFile() : this.getFile());
        return full;
    }

    protected void urlPath(StringBuffer buffer) {
        if (this.isRemote()) {
            buffer.append(this.getOriginalFileName());
        } else if (this.isInArchive()) {
            this.getParentLocator().urlPath(buffer);
            buffer.append(ARCHIVE_INDICATOR);
            buffer.append(this.getFile().getPath());
        } else {
            buffer.append(FileLocator.fileUtil().convertToURLSyntax(this.getFile().getPath()));
        }
    }

    protected File fileRef() throws IOException {
        if (this.isInArchive()) {
            ZipEntry entry = this.archiveEntry();
            InputStream archiveStream = this.container().getInputStream(entry);
            File tempFile = FileLocator.fileUtil().copyToTempFile(archiveStream, TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            return tempFile;
        }
        return this.getFile();
    }

    protected ZipFile archive() throws IOException {
        if (this.getZipFile() == null) {
            this.setZipFile(new ZipFile(this.fileRef()));
        }
        return this.getZipFile();
    }

    protected ZipFile container() throws IOException {
        if (this.isInArchive()) {
            return this.getParentLocator().archive();
        }
        return null;
    }

    protected File convertFromURLSyntax(File aFile) {
        String newStr = FileLocator.fileUtil().convertFromURLSyntax(aFile.getPath());
        newStr = FileLocator.str().replaceAll(newStr, ARCHIVE_INDICATOR, File.separator);
        return new File(newStr);
    }

    protected boolean isUnlocatedRemoteFile() {
        return this.getExists() == null;
    }

    protected void copyFromRemote() {
        File tempFile;
        if (this.getOriginalFileName() == null) {
            return;
        }
        try {
            AutoAuthenticationManager.instance().aboutToAccess(this.getOriginalFileName());
            tempFile = FileLocator.fileUtil().copyToTempFile(this.getOriginalFileName(), TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, false);
        }
        catch (IOException e) {
            this.setException(e);
            if (DEBUG) {
                this.logger().logException(e);
            }
            return;
        }
        if (tempFile != null) {
            this.setExists(tempFile.exists() ? Boolean.TRUE : Boolean.FALSE);
            this.setFile(tempFile);
        }
    }

    protected void setOriginalFileName(String newValue) {
        this.originalFileName = FileLocator.fileUtil().standardize(newValue);
    }

    protected Logger logger() {
        return LoggerProvider.getLogger();
    }
}

