/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.bif.filter.IObjectFilter;
import org.pf.file.FileInfo;
import org.pf.file.FileLocator;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;

public class ExtendedFileFilter
implements FilenameFilter,
IObjectFilter {
    public static final String PATTERN_SEPARATOR = ";";
    protected static final int DIR_CHECK_NAME = 1;
    protected static final int DIR_INCLUDE = 2;
    protected static final int DIR_EXCLUDE = 3;
    private List stringPatterns = new ArrayList();
    private int dirHandling = 1;
    private boolean restrictiveMode = false;
    private Character digitWildcard = null;

    protected List getStringPatterns() {
        return this.stringPatterns;
    }

    protected void setStringPatterns(List newValue) {
        this.stringPatterns = newValue;
    }

    protected int getDirHandling() {
        return this.dirHandling;
    }

    protected void setDirHandling(int newValue) {
        this.dirHandling = newValue;
    }

    protected boolean getRestrictiveMode() {
        return this.restrictiveMode;
    }

    protected void setRestrictiveMode(boolean newValue) {
        this.restrictiveMode = newValue;
    }

    protected Character getDigitWildcard() {
        return this.digitWildcard;
    }

    protected void setDigitWildcard(Character newValue) {
        this.digitWildcard = newValue;
    }

    public ExtendedFileFilter() {
    }

    public ExtendedFileFilter(String patternList) {
        this.addPatterns(patternList);
    }

    public ExtendedFileFilter(char wildcardForDigits) {
        this.setDigitWildcard(new Character(wildcardForDigits));
    }

    public ExtendedFileFilter(boolean restrictive) {
        this.setRestrictiveMode(restrictive);
    }

    public ExtendedFileFilter(char wildcardForDigits, boolean restrictive) {
        this(wildcardForDigits);
        this.setRestrictiveMode(restrictive);
    }

    public void addPattern(String pattern) {
        StringPattern stringPattern = null;
        stringPattern = this.createStringPattern(pattern, false);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, char digitWildcardChar) {
        StringPattern stringPattern = null;
        stringPattern = this.createStringPattern(pattern, false);
        stringPattern.setDigitWildcardChar(digitWildcardChar);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, boolean ignoreCase) {
        StringPattern stringPattern = null;
        stringPattern = this.createStringPattern(pattern, ignoreCase);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, boolean ignoreCase, char digitWildcardChar) {
        StringPattern stringPattern = null;
        stringPattern = this.createStringPattern(pattern, ignoreCase);
        stringPattern.setDigitWildcardChar(digitWildcardChar);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPatterns(String patternList) {
        if (this.str().isNullOrEmpty(patternList)) {
            return;
        }
        String[] parts = this.extractPatterns(patternList);
        int i = 0;
        while (i < parts.length) {
            if (this.hasDigitWildcard()) {
                this.addPattern(parts[i], true, this.getDigitWildcardChar());
            } else {
                this.addPattern(parts[i], true);
            }
            ++i;
        }
    }

    public void checkNameOfDirectories() {
        this.setDirHandling(1);
    }

    public void alwaysIncludeDirectories() {
        this.setDirHandling(2);
    }

    public void alwaysExcludeDirectories() {
        this.setDirHandling(3);
    }

    public boolean accept(File dir, String name) {
        File fileOrDir = new File(dir, name);
        if (fileOrDir.isDirectory()) {
            if (this.mustIncludeDirectories()) {
                this.postAcceptCheck(dir, name, fileOrDir, true);
                return true;
            }
            if (this.mustExcludeDirectories()) {
                this.postAcceptCheck(dir, name, fileOrDir, false);
                return false;
            }
        }
        boolean accepted = this.checkAgainstPatterns(name);
        this.postAcceptCheck(dir, name, fileOrDir, accepted);
        return accepted;
    }

    public boolean matches(Object object) {
        FileLocator locator;
        if (object instanceof String) {
            return this.matchesFile(new File((String)object));
        }
        if (object instanceof File) {
            return this.matchesFile((File)object);
        }
        if (object instanceof FileInfo) {
            return this.matchesFile(new File(((FileInfo)object).getFullName()));
        }
        if (object instanceof FileLocator && !(locator = (FileLocator)object).isRemote()) {
            return this.matchesFile(new File(locator.getOriginalFileName()));
        }
        return false;
    }

    public boolean mustIncludeDirectories() {
        return this.getDirHandling() == 2;
    }

    public boolean mustExcludeDirectories() {
        return this.getDirHandling() == 3;
    }

    protected void postAcceptCheck(File dir, String filename, File file, boolean accepted) {
    }

    protected boolean checkAgainstPatterns(String name) {
        Iterator iterator = null;
        StringPattern pattern = null;
        iterator = this.getStringPatterns().iterator();
        while (iterator.hasNext()) {
            pattern = (StringPattern)iterator.next();
            if (!pattern.matches(name)) continue;
            return true;
        }
        return false;
    }

    protected StringPattern createStringPattern(String pattern, boolean ignoreCase) {
        StringPattern strPattern = new StringPattern(pattern, ignoreCase);
        strPattern.multiCharWildcardMatchesEmptyString(!this.getRestrictiveMode());
        return strPattern;
    }

    protected String[] extractPatterns(String pattern) {
        return this.str().parts(pattern, PATTERN_SEPARATOR);
    }

    protected char getDigitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.getDigitWildcard().charValue();
        }
        return '\u0000';
    }

    protected boolean hasDigitWildcard() {
        return this.getDigitWildcard() != null;
    }

    protected boolean matchesFile(File file) {
        File dir = file.getParentFile();
        String filename = file.getName();
        return this.accept(dir, filename);
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

