/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.util.FileChooser;
import g2d.util.FileChooserEvent;
import g2d.util.FileChooserListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class Preferences {
    private static final boolean debug = false;
    public static final double GOLDEN_MEAN = 1.61803399;
    public static final int JF_DEFAULT_H = 512;
    public static final int JF_DEFAULT_W = 828;
    public static final String JF_W = "Width of JFrame";
    public static final String JF_H = "Height of JFrame";
    public static final String JF_X = "X of JFrame";
    public static final String JF_Y = "Y of JFrame";
    public static final int JD_DEFAULT_H = 100;
    public static final int JD_DEFAULT_W = 161;
    public static final String JD_W = "Width of JDialog";
    public static final String JD_H = "Height of JDialog";
    public static final String JD_X = "X of JDialog";
    public static final String JD_Y = "Y of JDialog";
    public static final String JSP_DIV = "Divider Location";
    public static final String FC_DIR = "Chooser directory";
    public static final String FC_FILE = "Chooser file";
    private final java.util.prefs.Preferences preferences;

    public Preferences(java.util.prefs.Preferences preferences) {
        this.preferences = preferences;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Preferences.this.save();
            }
        });
    }

    public Preferences(Class<?> clazz) {
        this(java.util.prefs.Preferences.userNodeForPackage(clazz));
    }

    public void save() {
        try {
            this.preferences.flush();
        }
        catch (Exception exception) {
            System.err.println("Preferences save: " + exception);
            exception.printStackTrace();
        }
    }

    public void manageJFrame(final JFrame jFrame, final String string) {
        int n = this.preferences.getInt(string + JF_W, 828);
        int n2 = this.preferences.getInt(string + JF_H, 512);
        int n3 = this.preferences.getInt(string + JF_X, 0);
        int n4 = this.preferences.getInt(string + JF_Y, 0);
        jFrame.setLocation(new Point(n3, n4));
        jFrame.setPreferredSize(new Dimension(n, n2));
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jFrame.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent componentEvent) {
                        Preferences.this.preferences.putInt(string + Preferences.JF_X, jFrame.getX());
                        Preferences.this.preferences.putInt(string + Preferences.JF_Y, jFrame.getY());
                    }

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        Preferences.this.preferences.putInt(string + Preferences.JF_W, jFrame.getWidth());
                        Preferences.this.preferences.putInt(string + Preferences.JF_H, jFrame.getHeight());
                    }
                });
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Preferences.this.preferences.putInt(string + Preferences.JF_W, jFrame.getWidth());
                Preferences.this.preferences.putInt(string + Preferences.JF_H, jFrame.getHeight());
                Preferences.this.preferences.putInt(string + Preferences.JF_X, jFrame.getX());
                Preferences.this.preferences.putInt(string + Preferences.JF_Y, jFrame.getY());
                Preferences.this.save();
            }
        });
    }

    public void manageJDialog(final JDialog jDialog, final String string) {
        int n = this.preferences.getInt(string + JD_W, 161);
        int n2 = this.preferences.getInt(string + JD_H, 100);
        int n3 = this.preferences.getInt(string + JD_X, 0);
        int n4 = this.preferences.getInt(string + JD_Y, 0);
        jDialog.setLocation(new Point(n3, n4));
        jDialog.setPreferredSize(new Dimension(n, n2));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent componentEvent) {
                        Preferences.this.preferences.putInt(string + Preferences.JD_X, jDialog.getX());
                        Preferences.this.preferences.putInt(string + Preferences.JD_Y, jDialog.getY());
                    }

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        Preferences.this.preferences.putInt(string + Preferences.JD_W, jDialog.getWidth());
                        Preferences.this.preferences.putInt(string + Preferences.JD_H, jDialog.getHeight());
                    }
                });
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Preferences.this.preferences.putInt(string + Preferences.JD_W, jDialog.getWidth());
                Preferences.this.preferences.putInt(string + Preferences.JD_H, jDialog.getHeight());
                Preferences.this.preferences.putInt(string + Preferences.JD_X, jDialog.getX());
                Preferences.this.preferences.putInt(string + Preferences.JD_Y, jDialog.getY());
                Preferences.this.save();
            }
        });
    }

    public void manageJSplitPane(final JSplitPane jSplitPane, final String string) {
        int n = this.preferences.getInt(string + JSP_DIV, -1);
        if (n < 0) {
            jSplitPane.setDividerLocation(0.5);
        } else {
            jSplitPane.setDividerLocation(n);
        }
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = jSplitPane.getDividerLocation();
                Preferences.this.preferences.putInt(string + Preferences.JSP_DIV, n);
            }
        });
    }

    public File getChosenFile(String string) {
        String string2 = this.preferences.get(string + FC_FILE, null);
        if (string2 != null) {
            return new File(string2);
        }
        return null;
    }

    public void manageFileChooser(FileChooser fileChooser, final String string) {
        File file;
        String string2 = System.getProperty("user.dir");
        String string3 = this.preferences.get(string + FC_DIR, string2);
        String string4 = this.preferences.get(string + FC_FILE, null);
        File file2 = new File(string3);
        fileChooser.setCurrentDirectory(file2);
        if (string4 != null && (file = new File(string4)).getParentFile().equals(file2)) {
            fileChooser.setSelectedFile(file);
        }
        fileChooser.addFileChooserListener(new FileChooserListener(){

            @Override
            public void directoryChanged(FileChooserEvent fileChooserEvent) {
                File file = fileChooserEvent.directory;
                if (file != null) {
                    Preferences.this.preferences.put(string + Preferences.FC_DIR, file.toString());
                    Preferences.this.save();
                }
            }

            @Override
            public void fileChosen(FileChooserEvent fileChooserEvent) {
                File file = fileChooserEvent.file;
                File file2 = fileChooserEvent.directory;
                if (file != null && file2 != null) {
                    Preferences.this.preferences.put(string + Preferences.FC_FILE, file.toString());
                    Preferences.this.preferences.put(string + Preferences.FC_DIR, file2.toString());
                    Preferences.this.save();
                }
            }
        });
    }
}

