/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.util.MutexException;

public class Mutex {
    private Thread owner = null;
    private boolean locked = false;
    private int count = 0;

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        while (true) {
            if (!this.locked) {
                this.owner = thread;
                this.locked = true;
                this.count = 1;
                return;
            }
            if (this.owner == thread) {
                assert (this.count > 0);
                ++this.count;
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void unlock() throws MutexException {
        Thread thread = Thread.currentThread();
        if (!this.locked) {
            throw new MutexException("Mutex.unlock illegal, not locked");
        }
        if (this.owner == thread) {
            --this.count;
            if (this.count == 0) {
                this.locked = false;
                this.notify();
            }
            return;
        }
        throw new MutexException("Mutex.unlock illegal, not owner");
    }
}

