/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Image {
    public static BufferedImage file2Image(String string) {
        return Image.file2Image(new File(string));
    }

    public static BufferedImage file2Image(File file) {
        BufferedImage bufferedImage;
        block5: {
            bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            finally {
                if (bufferedImage != null) break block5;
                throw new RuntimeException("file2Image: image is null!");
            }
        }
        return bufferedImage;
    }

    public static void image2File(BufferedImage bufferedImage, String string) {
        Image.image2File(bufferedImage, new File(string));
    }

    public static void image2File(BufferedImage bufferedImage, File file) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static BufferedImage url2Image(URL uRL) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return bufferedImage;
    }

    public static BufferedImage copy(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = bufferedImage.copyData(null);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2) {
        return Image.getScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        int n5 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            BufferedImage bufferedImage3 = new BufferedImage(n4, n3, n5);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n4 > n || n3 > n2);
        return bufferedImage2;
    }
}

