/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.jlambda.Closure;
import g2d.jlambda.Utils;
import g2d.util.Base64Coder;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

public final class IO {
    public static InputStream in = System.in;
    public static PrintStream out = System.out;
    public static PrintStream err = System.err;

    private IO() {
    }

    public static void setIO(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        in = inputStream;
        out = printStream;
        err = printStream2;
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        return file.delete();
    }

    public static String resolveLinks(String string) {
        return Utils.resolveLinks(string);
    }

    public static String interpretTilde(String string) {
        return Utils.interpretTilde(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapFile(String string, Closure closure, boolean bl) {
        if (closure == null) {
            return true;
        }
        boolean bl2 = false;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl && (string2 = string2.trim()).equals("")) continue;
                closure.applyClosure(string2);
            }
            bl2 = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean file2Collection(Collection<Object> collection, String string, Closure closure, boolean bl) {
        BufferedReader bufferedReader = null;
        boolean bl2 = false;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl && (string2 = string2.trim()).equals("")) continue;
                Object object = string2;
                if (closure != null) {
                    object = closure.applyClosure(string2);
                }
                if (collection == null) continue;
                collection.add(object);
            }
            bl2 = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    public static String[] file2Array(String string, boolean bl) {
        ArrayList<String> arrayList = IO.file2ArrayList(string, bl);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> file2ArrayList(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl && (string2 = string2.trim()).equals("")) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            arrayList = null;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static String file2String(File file, char c) {
        return Utils.file2String(file, c);
    }

    public static String file2String(String string, char c) {
        return Utils.file2String(string, c);
    }

    public static String file2String(File file) {
        return Utils.file2String(file);
    }

    public static String file2String(String string) {
        return Utils.file2String(string);
    }

    public static String reader2String(Reader reader) {
        return Utils.reader2String(reader);
    }

    public static String readln() {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = in.read()) != 10) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            err.println(exception.getMessage());
            return null;
        }
    }

    public static boolean collection2File(Collection<?> collection, String string, Closure closure, boolean bl) {
        if (collection != null) {
            try {
                string = IO.interpretTilde(string);
                PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(string, bl), true);
                for (Object object : collection) {
                    if (closure != null) {
                        object = closure.applyClosure(object);
                    }
                    if (object == null) continue;
                    printWriter.println(object);
                }
                printWriter.close();
                return true;
            }
            catch (IOException iOException) {
                err.println(iOException.getMessage());
                return false;
            }
        }
        return false;
    }

    public static boolean array2File(String[] stringArray, File file) {
        return IO.array2File(stringArray, file, false);
    }

    public static boolean array2File(String[] stringArray, File file, boolean bl) {
        if (stringArray != null && stringArray.length > 0) {
            try {
                String string = IO.interpretTilde(file.toString());
                PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(string, bl), true);
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.println(stringArray[i]);
                }
                printWriter.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean string2File(String string, File file) {
        String string2 = IO.interpretTilde(file.toString());
        return IO.string2File(string, string2, false);
    }

    public static boolean string2File(String string, String string2) {
        string2 = IO.interpretTilde(string2);
        return IO.string2File(string, string2, false);
    }

    public static boolean string2File(String string, String string2, boolean bl) {
        try {
            string2 = IO.interpretTilde(string2);
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(string2, bl), true);
            printWriter.println(string);
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean b64String2File(String string, File file) {
        return IO.b64String2File(string, IO.interpretTilde(file.toString()));
    }

    public static boolean b64String2File(String string, String string2) {
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            string2 = IO.interpretTilde(string2);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = Base64Coder.decodeLines(string);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            err.println("file2B64String: " + exception);
        }
        return bl;
    }

    public static String file2B64String(File file) {
        return IO.file2B64String(file.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2B64String(String string) {
        BufferedInputStream bufferedInputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        string = IO.interpretTilde(string);
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n2 = 72;
            byte[] byArray = new byte[n2 / 4 * 3];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                stringBuffer.append(Base64Coder.encode(byArray, 0, n));
                stringBuffer.append('\n');
            }
        }
        catch (Exception exception) {
            err.println("file2B64String: " + exception);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    public static String chooseFile(Component component) {
        return IO.chooseFile(component, System.getProperty("user.dir"));
    }

    public static String chooseFile(Component component, String string) {
        String string2 = null;
        JFileChooser jFileChooser = new JFileChooser(string);
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            File file = jFileChooser.getCurrentDirectory();
            string2 = file.toString();
            string2 = string2 + File.separator;
            string2 = string2 + jFileChooser.getSelectedFile().getName();
        }
        return string2;
    }

    public static boolean screenshot(Component component, String string, String string2) {
        try {
            int n = component.getWidth();
            int n2 = component.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            component.paint(graphics2D);
            graphics2D.dispose();
            File file = new File(string2);
            ImageIO.write((RenderedImage)bufferedImage, string, file);
            return true;
        }
        catch (Exception exception) {
            System.err.println("g2d.util.IO.screenshot: " + exception);
            return false;
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            fileChannel2 = fileOutputStream.getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        }
        catch (Exception exception) {
            System.err.println("IO.copyFile: " + exception.getMessage());
        }
        if (fileChannel != null) {
            fileChannel.close();
        }
        if (fileChannel2 != null) {
            fileChannel2.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }
}

