/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.util.FileChooserEvent;
import g2d.util.FileChooserListener;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;

public class FileChooser
extends JFileChooser {
    private List<FileChooserListener> listeners = new ArrayList<FileChooserListener>();
    private boolean initialized = true;

    public void addFileChooserListener(FileChooserListener fileChooserListener) {
        this.listeners.add(fileChooserListener);
    }

    public void removeFileChooserListener(FileChooserListener fileChooserListener) {
        this.listeners.remove(fileChooserListener);
    }

    protected void fireFileChooserEvent(FileChooserEvent fileChooserEvent) {
        int n = fileChooserEvent.getID();
        switch (n) {
            case 0: {
                for (FileChooserListener fileChooserListener : this.listeners) {
                    fileChooserListener.directoryChanged(fileChooserEvent);
                }
                break;
            }
            case 1: {
                for (FileChooserListener fileChooserListener : this.listeners) {
                    fileChooserListener.fileChosen(fileChooserEvent);
                }
                break;
            }
        }
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (this.initialized && file != null) {
            file = file.getAbsoluteFile();
            this.fireFileChooserEvent(new FileChooserEvent(this, 0, null, file));
        }
        super.setCurrentDirectory(file);
    }

    @Override
    public void setSelectedFile(File file) {
        if (this.initialized && file != null) {
            file = file.getAbsoluteFile();
            this.fireFileChooserEvent(new FileChooserEvent(this, 1, file, null));
        }
        super.setSelectedFile(file);
    }

    @Override
    public int showDialog(Component component, String string) {
        int n = super.showDialog(component, string);
        this.handleApproval(n);
        return n;
    }

    @Override
    public int showOpenDialog(Component component) {
        int n = super.showOpenDialog(component);
        this.handleApproval(n);
        return n;
    }

    @Override
    public int showSaveDialog(Component component) {
        int n = super.showSaveDialog(component);
        this.handleApproval(n);
        return n;
    }

    private void handleApproval(int n) {
        if (this.initialized) {
            switch (n) {
                case 0: {
                    File file = this.getSelectedFile();
                    File file2 = file.getParentFile();
                    this.fireFileChooserEvent(new FileChooserEvent(this, 1, file, file2));
                    break;
                }
            }
        }
    }
}

