/*
 * Decompiled with CFR 0.152.
 */
package g2d.util;

import g2d.Main;
import g2d.jlambda.Code;
import g2d.util.IO;
import g2d.util.NetworkDisconnectionException;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;

public final class ActorMsg {
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static final int SIZE = 32;
    private static int failures = 0;
    private byte[] raw;
    private int start;
    private int length;
    private String sender;
    private String body;
    private Type type = Type.UNKNOWN;
    public int cursor;
    public Token lastToken;
    private static int msgCounter = 0;

    private ActorMsg() {
    }

    private boolean sanityCheck() {
        if (this.raw == null) {
            return false;
        }
        if (this.raw.length < 3) {
            return false;
        }
        if (this.raw[0] != 40) {
            return false;
        }
        this.cursor = 1;
        this.length = this.raw.length;
        while (this.raw[this.length - 1] == 10) {
            --this.length;
        }
        if (this.raw[this.length - 1] != 41) {
            return false;
        }
        Token token = this.getNextToken();
        if (token == null) {
            return false;
        }
        this.sender = token.toString();
        this.start = this.cursor;
        this.type = Type.RAW;
        return true;
    }

    public String getSender() {
        return this.sender;
    }

    public String getBody() {
        if (this.type == Type.RAW) {
            this.body = new String(this.raw, this.start, this.length - this.start - 1).trim();
            this.raw = null;
            this.type = Type.COMMAND;
        }
        return this.body;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public Type getType() {
        return this.type;
    }

    public static ActorMsg readActorMsg() {
        int n;
        int n2 = n = ActorMsg.readInt();
        ActorMsg actorMsg = new ActorMsg();
        int n3 = 0;
        int n4 = 0;
        actorMsg.raw = new byte[n];
        while (n4 != n) {
            try {
                n3 = IO.in.read(actorMsg.raw, n4, n2);
                n4 += n3;
                n2 -= n3;
            }
            catch (Exception exception) {
                IO.err.println(exception);
                break;
            }
        }
        if (n4 != n) {
            IO.err.println("bytesTotal != bytesDue: " + n4 + " " + n);
        }
        if (!actorMsg.sanityCheck()) {
            return null;
        }
        return actorMsg;
    }

    private static void incrementFailures() {
        if (++failures >= 10) {
            if (!Main.isRemote()) {
                IO.err.println("ActorMsg.readInt exceeded failure limit: exiting!");
            }
            if (Main.isRemote() && Main.isGadget()) {
                throw new NetworkDisconnectionException();
            }
            System.exit(0);
        }
    }

    public static int readInt() {
        byte[] byArray = new byte[32];
        int n = 0;
        try {
            int n2;
            for (n2 = 0; n2 < 32; ++n2) {
                if (IO.in.read(byArray, n2, 1) == -1) {
                    ActorMsg.incrementFailures();
                    return 0;
                }
                if (byArray[n2] == 10) break;
            }
            if (n2 == 32) {
                IO.err.println("ActorMsg.readInt failed to see a \\n!");
                return 0;
            }
            n = Integer.parseInt(new String(byArray, 0, n2));
            failures = 0;
            return n;
        }
        catch (Exception exception) {
            if (!Main.isRemote()) {
                IO.err.println("ActorMsg.readInt failed: " + exception);
            }
            ActorMsg.incrementFailures();
            return n;
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return this.toString(true, 100);
    }

    public String toString(boolean bl, int n) {
        String string = "Sender = \"" + this.getSender() + "\"\n";
        if (this.type != Type.RAW) {
            String string2 = this.getBody();
            if (bl) {
                string2 = string2.substring(0, Math.min(string2.length(), n));
            }
            string = string + "Body = \"" + string2 + "\"\n";
        }
        string = string + "Type = \"" + (Object)((Object)this.getType()) + "\"\n";
        return string;
    }

    public static void sendActorMsg(OutputStream outputStream, String string) {
        ActorMsg.sendActorMsg(outputStream, string, null);
    }

    public static void sendActorMsg(OutputStream outputStream, String string, byte[] byArray) {
        int n = string.length();
        if (byArray != null) {
            n += byArray.length;
        }
        String string2 = "" + n + "\n" + string;
        try {
            outputStream.write(string2.getBytes());
            if (byArray != null) {
                outputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            IO.err.println(exception);
        }
    }

    public static void send(String string, String string2, String string3) {
        ActorMsg.send(string, string2, string3, null);
    }

    public static void send(String string, String string2, Code code) {
        ActorMsg.send(string, string2, code.toString(), null);
    }

    public static void send(String string, String string2, String string3, byte[] byArray) {
        String string4 = string + "\n" + string2 + "\n" + string3;
        ActorMsg.sendActorMsg(IO.out, string4, byArray);
        if (VERBOSE) {
            ActorMsg.sendActorMsg(IO.err, string4);
        }
    }

    public String dump() {
        String string = "";
        try {
            File file = File.createTempFile("msg" + ++msgCounter + "_", ".msg");
            IO.string2File(this.toString(), file);
            string = file.toString();
        }
        catch (Exception exception) {
            IO.err.println(exception);
        }
        return string;
    }

    public byte[] bytesRemaining() {
        ++this.cursor;
        int n = this.length - this.cursor - 1;
        if (n >= 0) {
            byte[] byArray = Arrays.copyOfRange(this.raw, this.cursor, this.length - 1);
            return byArray;
        }
        return null;
    }

    public Token getNextToken() {
        Token token = new Token();
        while (this.cursor < this.length && Character.isWhitespace(this.raw[this.cursor])) {
            ++this.cursor;
        }
        if (this.cursor == this.length) {
            return null;
        }
        token.start = this.cursor;
        while (this.cursor < this.length && !Character.isWhitespace(this.raw[this.cursor])) {
            ++this.cursor;
        }
        token.stop = this.cursor;
        this.lastToken = token;
        return token;
    }

    public class Token {
        private String self;
        protected int start;
        protected int stop;

        protected Token() {
        }

        public String toString() {
            int n = this.stop - this.start;
            if (this.self == null && n >= 0) {
                this.self = new String(ActorMsg.this.raw, this.start, n);
            }
            return this.self;
        }

        public byte byteAt(int n) {
            if (n < this.stop - this.start) {
                return ActorMsg.this.raw[this.start + n];
            }
            return -1;
        }
    }

    public static enum Type {
        UNKNOWN,
        RAW,
        COMMAND;

    }
}

