/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.Algebra;
import g2d.terms.Sort;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Variable {
    public final Sort sort;
    public final String name;
    private static final String simplePatternString = "\\s*(\\w+)\\s*";
    private static final Pattern simplePattern;
    private static final String sortedPatternString = "\\s*(\\w+)\\s*:\\s*(\\w+)\\s*";
    private static final Pattern sortedPattern;

    public Variable(String string, Sort sort) {
        this.name = string;
        this.sort = sort;
        if (string == null || sort == null) {
            throw new IllegalArgumentException("Variable constructor's name or sort argument cannot be null");
        }
    }

    public String toString() {
        return this.name + ":" + this.sort.toString();
    }

    int length() {
        return this.name.length() + this.sort.length() + 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Variable variable = (Variable)object;
        return !(this.name != variable.name && !this.name.equals(variable.name) || this.sort != variable.sort && !this.sort.equals(variable.sort));
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.sort.hashCode();
        return n;
    }

    public static Variable parseDeclaration(String string, Sort sort, Algebra algebra, String[] stringArray) {
        if (string == null || sort == null || algebra == null || stringArray == null) {
            throw new IllegalArgumentException("Bad arguments to Variable.parseDeclaration");
        }
        if (string.indexOf(58) == -1) {
            Matcher matcher = simplePattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                stringArray[0] = string + " looks good as a simple variable";
                return new Variable(string2, sort);
            }
            stringArray[0] = "\"" + string + "\" DOES NOT look good as a simple variable";
        } else {
            Matcher matcher = sortedPattern.matcher(string);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                Sort sort2 = new Sort(string4);
                if (algebra.subsorter.isSubsort(sort2, sort)) {
                    stringArray[0] = string3 + " looks good as a subsorted variable of type " + string4;
                    return new Variable(string3, sort2);
                }
                stringArray[0] = sort2 + " is not a valid subsort of " + sort;
            } else {
                stringArray[0] = string + " DOES NOT look good as a subsorted variable";
            }
        }
        return null;
    }

    static {
        sortedPattern = Pattern.compile(sortedPatternString);
        simplePattern = Pattern.compile(simplePatternString);
    }
}

