/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.HolePosition;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.Term;
import g2d.terms.TermPosition;
import g2d.terms.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class VarTerm
extends Term {
    public final Variable variable;
    public final int hashCode;

    public VarTerm(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("VarTerm()'s variable argument cannot be null");
        }
        this.variable = variable;
        this.hashCode = this.variable.hashCode();
    }

    @Override
    public Sort sort() {
        return this.variable.sort;
    }

    @Override
    public Set<Term> subterms() {
        HashSet<Term> hashSet = new HashSet<Term>();
        hashSet.add(this);
        return hashSet;
    }

    @Override
    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.variable.toString());
    }

    @Override
    public int length() {
        return this.variable.length();
    }

    @Override
    public int rank() {
        return 0;
    }

    @Override
    public int holeCount() {
        return 0;
    }

    @Override
    public Term copy() {
        return new VarTerm(this.variable);
    }

    @Override
    public Term expand(int n, Term term, Subsorter subsorter) {
        return this;
    }

    @Override
    public Term expand(Term term, Term term2, Subsorter subsorter) {
        return this == term ? term2 : this;
    }

    @Override
    public int getHolePositions(int n, ArrayList<HolePosition> arrayList) {
        return this.variable.length();
    }

    @Override
    public int getSubtermPositions(int n, Sort sort, ArrayList<TermPosition> arrayList) {
        arrayList.add(new TermPosition(n, sort, this));
        return this.variable.length();
    }

    public static VarTerm fromStrings(String string, String string2) {
        Sort sort = new Sort(string2);
        Variable variable = new Variable(string, sort);
        return new VarTerm(variable);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        VarTerm varTerm = (VarTerm)object;
        return this.variable == varTerm.variable || this.variable.equals(varTerm.variable);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

