/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.Hole;
import g2d.terms.HolePosition;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.Term;
import g2d.terms.TermPosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class HoleTerm
extends Term {
    public final Hole hole;
    public final int hashCode;

    public HoleTerm(Hole hole) {
        if (hole == null) {
            throw new IllegalArgumentException("HoleTerm constructor's hole argument cannot be null");
        }
        this.hole = hole;
        this.hashCode = this.hole.hashCode();
    }

    @Override
    public Sort sort() {
        return this.hole.sort;
    }

    @Override
    public Set<Term> subterms() {
        HashSet<Term> hashSet = new HashSet<Term>();
        return hashSet;
    }

    @Override
    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.hole.toString());
    }

    @Override
    public int length() {
        return this.hole.length();
    }

    @Override
    public int rank() {
        return 0;
    }

    @Override
    public int holeCount() {
        return 1;
    }

    @Override
    public Term copy() {
        return new HoleTerm(this.hole);
    }

    @Override
    public Term expand(int n, Term term, Subsorter subsorter) {
        if (n == 1 && subsorter.isSubsort(term.sort(), this.sort())) {
            return term;
        }
        return null;
    }

    @Override
    public Term expand(Term term, Term term2, Subsorter subsorter) {
        return this == term ? term2 : this;
    }

    @Override
    public int getHolePositions(int n, ArrayList<HolePosition> arrayList) {
        arrayList.add(new HolePosition(n, this.hole));
        return this.hole.length();
    }

    @Override
    public int getSubtermPositions(int n, Sort sort, ArrayList<TermPosition> arrayList) {
        arrayList.add(new TermPosition(n, sort, this));
        return this.hole.length();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        HoleTerm holeTerm = (HoleTerm)object;
        return this.hole == holeTerm.hole || this.hole.equals(holeTerm.hole);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static HoleTerm fromSort(Sort sort) {
        return new HoleTerm(new Hole(sort));
    }
}

