/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.netviewer.StatusBar;
import g2d.npa.NPAFrame;
import g2d.npa.examples.Examples;
import g2d.terms.Algebra;
import g2d.terms.Constructor;
import g2d.terms.Hole;
import g2d.terms.HolePosition;
import g2d.terms.HoleTerm;
import g2d.terms.Sort;
import g2d.terms.Term;
import g2d.terms.VarTerm;
import g2d.terms.Variable;
import g2d.util.Preferences;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class HoleEditor
extends JPanel
implements CaretListener {
    private static final boolean debug = false;
    static final Color HILIT_COLOR = Color.LIGHT_GRAY;
    private final Window parent;
    private final Algebra algebra;
    private final JTextField termField = new JTextField();
    private boolean listening = true;
    private final StatusBar status = new StatusBar("");
    private final StatusBar controls = new StatusBar("");
    private final JButton cancel = new JButton("Cancel");
    private final JButton ok = new JButton("OK");
    private final JButton undo = new JButton("Undo");
    private Stack<Term> history = new Stack();
    private Term term = null;
    private final Term initialTerm;
    private final boolean usePool;
    private ArrayList<HolePosition> holePositions;
    private final Highlighter hilit;
    private final Highlighter.HighlightPainter painter;
    private Object tag = null;
    private JComboBox currentChooser = null;
    private HolePosition currentHit = null;

    public HoleEditor(Window window, Algebra algebra) {
        this(window, algebra, null);
    }

    public HoleEditor(Window window, Algebra algebra, boolean bl) {
        this(window, algebra, null, null, bl);
    }

    public HoleEditor(Window window, Algebra algebra, Sort sort, Term term) {
        this(window, algebra, null, null, false);
    }

    public HoleEditor(Window window, Algebra algebra, Term term, boolean bl) {
        this(window, algebra, null, term, bl);
    }

    public HoleEditor(Window window, Algebra algebra, Sort sort, Term term, boolean bl) {
        super(new GridLayout(3, 1));
        this.algebra = algebra;
        this.parent = window;
        this.usePool = bl;
        if (sort != null) {
            this.initialTerm = HoleTerm.fromSort(sort);
            if (term != null) {
                Sort sort2;
                if (algebra != null && !algebra.subsorter.isSubsort(sort2 = term.sort(), sort)) {
                    throw new IllegalArgumentException("HoleEditor: " + term + " is not a subsort of " + sort);
                }
                this.pushTerm(this.initialTerm);
            }
        } else {
            this.initialTerm = term;
        }
        this.termField.setEditable(false);
        this.termField.addCaretListener(this);
        this.hilit = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(HILIT_COLOR);
        this.termField.setHighlighter(this.hilit);
        this.status.addButton(this.ok);
        this.status.addButton(this.undo);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HoleEditor.this.doOK();
            }
        });
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HoleEditor.this.doUndo();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HoleEditor.this.doCancel();
            }
        });
        this.add(this.termField);
        this.add(this.controls);
        this.add(this.status);
        this.updateTerm(term);
    }

    public HoleEditor(Window window, Algebra algebra, Term term) {
        this(window, algebra, null, term);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.listening) {
            HolePosition holePosition;
            int n;
            int n2;
            int n3 = caretEvent.getDot();
            int n4 = n3 < (n2 = caretEvent.getMark()) ? n3 : n2;
            int n5 = n = n3 < n2 ? n2 : n3;
            if (n4 == n && (holePosition = this.hitDetection(n4)) != null) {
                this.updateUI(holePosition);
            }
        }
    }

    public Term getTerm() {
        return this.term;
    }

    private void pushTerm(Term term) {
        if (term != null) {
            this.history.push(term);
        }
    }

    private void popTerm() {
        if (!this.history.empty()) {
            Term term = this.history.pop();
            this.updateTerm(term);
        } else {
            this.updateTerm(null);
        }
    }

    private void updateTerm(Term term) {
        this.term = term;
        this.listening = false;
        if (this.term != null) {
            this.termField.setText(term.toString());
            this.holePositions = term.getHolePositions();
        } else {
            this.termField.setText("");
            this.holePositions = null;
        }
        this.listening = true;
        this.currentHit = null;
        this.updateUI(null);
    }

    private HolePosition hitDetection(int n) {
        if (this.holePositions != null) {
            for (HolePosition holePosition : this.holePositions) {
                if (n < holePosition.start || n > holePosition.stop) continue;
                return holePosition;
            }
        }
        return null;
    }

    private void updateUI(HolePosition holePosition) {
        if (this.tag != null) {
            this.hilit.removeHighlight(this.tag);
            this.tag = null;
        }
        this.currentHit = holePosition;
        if (this.term == null) {
            JComboBox jComboBox = this.sortChooser();
            this.clearControls();
            this.controls.setStatus("Choose a sort for your term!");
            this.controls.buttons.add(jComboBox);
            this.currentChooser = jComboBox;
        } else if (holePosition != null) {
            try {
                this.tag = this.hilit.addHighlight(holePosition.start, holePosition.stop, this.painter);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
            JComboBox jComboBox = this.subtermChooser(holePosition.hole.sort);
            this.clearControls();
            this.controls.setStatus("Enter a variable name, or choose an operation");
            this.controls.buttons.add(jComboBox);
            this.currentChooser = jComboBox;
            this.controls.addButton(this.cancel);
        } else if (this.term.holeCount() > 0) {
            this.controls.setStatus("Select a hole to fill.");
        } else {
            this.controls.setStatus("Your term looks complete!");
        }
        this.validate();
        this.repaint();
    }

    private JComboBox subtermChooser(Sort sort) {
        Object object;
        Object object2;
        ArrayList<Constructor> arrayList = this.algebra.getConstructorsBySubsort(sort);
        JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
        if (this.usePool && (object2 = this.algebra.getPool(sort)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Term term = (Term)object.next();
                jComboBox.addItem(term);
            }
        }
        jComboBox.setEditable(true);
        object2 = jComboBox.getEditor();
        object = (JTextField)object2.getEditorComponent();
        ((JTextField)object).setColumns(10);
        jComboBox.setSelectedItem("");
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HoleEditor.this.doEnter();
            }
        });
        return jComboBox;
    }

    private JComboBox sortChooser() {
        JComboBox<Sort> jComboBox = new JComboBox<Sort>(this.algebra.sorts);
        jComboBox.setEditable(false);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HoleEditor.this.doEnter();
            }
        });
        return jComboBox;
    }

    private void clearControls() {
        this.invalidate();
        this.controls.setStatus("");
        if (this.currentChooser != null) {
            this.controls.buttons.remove(this.currentChooser);
            this.currentChooser = null;
        }
        this.controls.buttons.remove(this.cancel);
        this.validate();
        this.repaint();
    }

    private void doOK() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
        System.err.println("doOK()");
        this.add2Pool();
    }

    private void add2Pool() {
        if (this.usePool && this.term != null && this.term.holeCount() == 0) {
            System.err.println("add2Pool(): yes " + this.term);
            this.algebra.addTerm2Pool(this.term);
            System.err.println("subterms: " + this.term.subterms());
        } else {
            System.err.println("add2Pool() no");
        }
    }

    private void doUndo() {
        this.clearControls();
        if (this.initialTerm != this.term) {
            this.popTerm();
            this.controls.setStatus("Select a hole to fill.");
        } else {
            this.controls.setStatus("Can't undo past this point.", true);
        }
    }

    private void doEnter() {
        Object object;
        if (this.currentChooser != null && (object = this.currentChooser.getSelectedItem()) != null) {
            if (object instanceof Sort) {
                Sort sort = (Sort)object;
                Hole hole = new Hole(sort);
                HoleTerm holeTerm = new HoleTerm(hole);
                this.clearControls();
                this.updateTerm(holeTerm);
            } else if (object instanceof Constructor) {
                Constructor constructor = (Constructor)object;
                Term term = constructor.expand(this.algebra.subsorter);
                Term term2 = this.term;
                Term term3 = this.term.expand(this.currentHit.index, term, this.algebra.subsorter);
                this.pushTerm(term2);
                this.clearControls();
                this.updateTerm(term3);
            } else if (object instanceof String) {
                String[] stringArray;
                Sort sort = this.currentHit.hole.sort;
                String string = ((String)object).trim();
                Variable variable = Variable.parseDeclaration(string, sort, this.algebra, stringArray = new String[1]);
                if (variable != null) {
                    VarTerm varTerm = new VarTerm(variable);
                    Term term = this.term;
                    Term term4 = this.term.expand(this.currentHit.index, (Term)varTerm, this.algebra.subsorter);
                    this.pushTerm(term);
                    this.clearControls();
                    this.updateTerm(term4);
                } else {
                    this.controls.setStatus(stringArray[0], true);
                }
            } else if (object instanceof Term) {
                Term term = (Term)object;
                Term term5 = this.term;
                Term term6 = this.term.expand(this.currentHit.index, term, this.algebra.subsorter);
                this.pushTerm(term5);
                this.clearControls();
                this.updateTerm(term6);
            }
        }
    }

    private void doCancel() {
        this.clearControls();
        this.updateUI(null);
    }

    public static void main() {
        HoleEditor.main(null);
    }

    public static void main(Term term) {
        HoleEditor.main(null, term);
    }

    public static void main(Sort sort, Term term) {
        JFrame jFrame = new JFrame("HoleEditor Tester");
        System.err.println(term);
        HoleEditor holeEditor = new HoleEditor(jFrame, Examples.NSPK, sort, term, true);
        Preferences preferences = NPAFrame.npaPreferences;
        preferences.manageJFrame(jFrame, "_termtester");
        jFrame.getContentPane().add(holeEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

