/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.swing.IOPMenuItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IOPTextMenu
extends JPanel
implements ListSelectionListener {
    private DefaultListModel<Object> listModel = new DefaultListModel();
    private JList<Object> list = new JList<Object>(this.listModel);
    public static final int MIN_ROWS = 4;
    public static final int MAX_ROWS = 7;

    public IOPTextMenu() {
        this("");
    }

    public IOPTextMenu(String string) {
        this(string, null);
    }

    public IOPTextMenu(String string, List<?> list) {
        super(new BorderLayout(0, 5));
        Object object2;
        this.add((Component)new JLabel(string), "First");
        if (list != null) {
            for (Object object2 : list) {
                if (!(object2 instanceof IOPMenuItem)) continue;
                this.addMItem((IOPMenuItem)object2);
            }
        }
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.setLayoutOrientation(0);
        this.list.setCellRenderer(new ItemRenderer());
        this.list.setVisibleRowCount(Math.max(4, Math.min(7, list.size())));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBackground(Color.white);
        object2 = jScrollPane.getPreferredSize();
        jScrollPane.setMinimumSize((Dimension)object2);
        this.add((Component)jScrollPane, "Center");
    }

    public void addMItem(IOPMenuItem iOPMenuItem) {
        if (iOPMenuItem == null) {
            return;
        }
        this.listModel.addElement(iOPMenuItem);
        if (iOPMenuItem.getShortcut() != null) {
            final IOPMenuItem iOPMenuItem2 = iOPMenuItem;
            this.getInputMap(2).put(KeyStroke.getKeyStroke(iOPMenuItem.getShortcut().charValue()), iOPMenuItem + "!doAction");
            this.getActionMap().put(iOPMenuItem + "!doAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IOPTextMenu.this.list.setSelectedValue(iOPMenuItem2, false);
                }
            });
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && this.list.getSelectedIndex() != -1) {
            ((IOPMenuItem)this.list.getSelectedValue()).doAction(this, listSelectionEvent);
        }
    }

    class ItemRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ItemRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            IOPMenuItem iOPMenuItem;
            Character c;
            if (bl || bl2) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(object.toString());
            if (object instanceof IOPMenuItem && (c = (iOPMenuItem = (IOPMenuItem)object).getShortcut()) != null) {
                int n2 = iOPMenuItem.toString().indexOf(c.toString().toUpperCase());
                if (n2 == -1) {
                    this.setDisplayedMnemonic(c.charValue());
                } else {
                    this.setDisplayedMnemonicIndex(n2);
                }
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            return this;
        }
    }
}

