/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class IOPDropdownButton
extends JButton {
    private DDPopupMenu menu = new DDPopupMenu();
    private boolean visible = false;

    public void setHeight(int n) {
        Dimension dimension = this.getPreferredSize();
        if (dimension != null) {
            dimension.height = n;
            this.setMaximumSize(dimension);
        }
    }

    public IOPDropdownButton() {
        this.ddinit(null);
    }

    public IOPDropdownButton(String string) {
        super(string);
        this.ddinit(string);
    }

    public void addMenuItem(String string, Closure closure) {
        this.addMenuItem(string, null, closure);
    }

    public void addMenuItem(String string, String string2, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("IOPDropdownButton.addMenuItem: closure arity not 2 -- " + closure);
        } else {
            DDMenuItem dDMenuItem = new DDMenuItem(string, closure);
            if (string2 != null) {
                dDMenuItem.setToolTipText(string2);
            }
            this.menu.add(dDMenuItem);
        }
    }

    public void addMenu(String string, String[] stringArray, Closure closure) {
        this.addMenu(string, stringArray, null, closure);
    }

    public void addMenu(String string, String[] stringArray, String[] stringArray2, Closure closure) {
        if (closure.getArity() != 1) {
            IO.err.println("IOPDropdownButton.addMenu: closure arity not 1 -- " + closure);
        } else {
            JMenu jMenu = new JMenu(string);
            for (int i = 0; i < stringArray.length; ++i) {
                Closure closure2 = (Closure)closure.applyClosure(stringArray[i]);
                DDMenuItem dDMenuItem = new DDMenuItem(stringArray[i], closure2);
                if (stringArray2 != null && stringArray2[i] != null) {
                    dDMenuItem.setToolTipText(stringArray2[i]);
                }
                jMenu.add(dDMenuItem);
            }
            this.menu.add(jMenu);
        }
    }

    private void ddinit(String string) {
        this.setAction(new AbstractAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = IOPDropdownButton.this.getHeight();
                int n2 = IOPDropdownButton.this.getX();
                int n3 = IOPDropdownButton.this.getY();
                if (!IOPDropdownButton.this.visible) {
                    IOPDropdownButton.this.menu.show(IOPDropdownButton.this.getParent(), n2, n3 + n);
                }
            }
        });
    }

    public class DDPopupMenu
    extends JPopupMenu {
        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            IOPDropdownButton.this.visible = bl;
        }
    }

    public class DDMenuItem
    extends JMenuItem {
        private Closure caction;

        DDMenuItem(String string, Closure closure) {
            this.caction = closure;
            this.setAction(new AbstractAction(string){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DDMenuItem.this.caction != null) {
                        DDMenuItem.this.caction.applyClosure(IOPDropdownButton.this, actionEvent);
                    }
                }
            });
        }
    }
}

