/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.util.BrowserLauncher;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;

public class HTMLPane
extends JEditorPane {
    private BrowserLauncher launcher;
    private boolean reusing = false;
    private HyperlinkListener linklistener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                HTMLPane.this.launcher.openURLinBrowser(hyperlinkEvent.getURL().toString());
            }
        }
    };

    public HTMLPane() {
        this.launcher = new BrowserLauncher();
        this.setContentType("text/html");
        this.setMargin(new Insets(25, 25, 25, 25));
        this.setEditable(false);
        this.addHyperlinkListener(this.linklistener);
    }

    public void displayText(String string) {
        try {
            if (this.reusing) {
                EditorKit editorKit = this.getEditorKit();
                this.setDocument(editorKit.createDefaultDocument());
            }
            this.setText(string);
            this.reusing = true;
            this.revalidate();
        }
        catch (Exception exception) {
            System.err.println("displayText: " + exception);
        }
    }
}

