/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.subset.DEvent;
import g2d.subset.Quaternary;
import g2d.subset.SComboBox;
import g2d.subset.SEditorPane;
import g2d.subset.SEvent;
import g2d.subset.STabbedPane;
import g2d.subset.STree;
import g2d.subset.StateSpace;
import g2d.subset.Universe;
import g2d.subset.Urelement;
import g2d.swing.IOPFileChooser;
import g2d.swing.IOPFileFilter;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SDialog
extends JDialog {
    protected Frame parent;
    public static boolean bughunter = false;
    protected Universe universe;
    private volatile boolean chosen = false;
    protected int[] indices = null;
    private SEditorPane subset = new SEditorPane();
    private STabbedPane tabbedPane = new STabbedPane();
    private SComboBox sedit;
    private boolean uninitialized = true;

    public Universe getUniverse() {
        return this.universe;
    }

    public void setUniverse(String[] stringArray) {
        this.setUniverse(new Universe(stringArray));
    }

    public void setUniverse(String[] stringArray, String[] stringArray2) {
        this.setUniverse(new Universe(stringArray, stringArray2));
    }

    public void setUniverse(Universe universe) {
        this.universe = universe;
        this.sedit = new SComboBox(universe);
        this.subset.setUniverse(universe);
        this.add((Component)this.sedit, "North");
    }

    public STree addTab(String string) {
        STree sTree = new STree(string, this.universe);
        this.tabbedPane.addTab(string, sTree);
        return sTree;
    }

    public STree addTab(String string, Comparator<Object> comparator) {
        STree sTree = new STree(string, this.universe, comparator);
        this.tabbedPane.addTab(string, sTree);
        return sTree;
    }

    public int[] getSelected() {
        return this.getSelected(1);
    }

    public int[] getSelected(int n) {
        if (!this.chosen) {
            return null;
        }
        int[] nArray = this.universe.getIndices(n);
        return nArray;
    }

    public String[] getStrings() {
        return this.getStrings(1);
    }

    public String[] getStrings(int n) {
        if (!this.chosen) {
            return null;
        }
        String[] stringArray = this.universe.getStrings(n);
        if (bughunter) {
            IO.err.println("SDialog.getStrings(" + n + "): chosen=" + this.chosen + " picked=" + stringArray);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    IO.err.println("\tpicked[" + i + "] = " + stringArray[i]);
                }
            }
        }
        return stringArray;
    }

    public boolean setSelected(int[] nArray) {
        return this.setSelected(nArray, 1);
    }

    public boolean setSelected(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Urelement urelement = this.universe.getUrelement(nArray[i]);
            if (urelement == null) continue;
            urelement.setState(n);
        }
        this.universe.fireSEvent(new SEvent());
        return true;
    }

    private void _fireUpdate() {
        DEvent dEvent = new DEvent(this.universe, 1);
        SEvent sEvent = new SEvent(dEvent);
        this.universe.fireSEvent(sEvent);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.uninitialized) {
            this._fireUpdate();
            this.uninitialized = false;
        }
        super.setVisible(bl);
    }

    public SDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.parent = frame;
        this.setLayout(new BorderLayout());
        this.subset.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.subset);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.tabbedPane);
        jSplitPane.setBottomComponent(jScrollPane);
        Dimension dimension = new Dimension(100, 100);
        this.tabbedPane.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(500);
        jSplitPane.setPreferredSize(new Dimension(500, 600));
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void loadFile() {
        String[] stringArray = this.getEntriesFromFile();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split("\\s+");
            if (stringArray2.length == 1) {
                this.universe.setState(stringArray2[0], 1);
                continue;
            }
            this.universe.setState(stringArray2[0], StateSpace.string2State(stringArray2[1]));
        }
    }

    private JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Load File");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDialog.this.loadFile();
            }
        });
        JButton jButton2 = new JButton("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton("OK");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDialog.this.setVisible(false);
                SDialog.this.chosen = true;
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton3);
        return jPanel;
    }

    public String[] getEntriesFromFile() {
        String[] stringArray = null;
        IOPFileChooser iOPFileChooser = new IOPFileChooser("raw_text_area");
        IOPFileFilter iOPFileFilter = new IOPFileFilter("Text Files");
        iOPFileFilter.setFilesOnly(true);
        iOPFileFilter.addExtension("txt");
        iOPFileChooser.setFileFilter(iOPFileFilter);
        int n = ((JFileChooser)iOPFileChooser).showOpenDialog(this.parent);
        if (n == 0) {
            try {
                stringArray = IO.file2Array(iOPFileChooser.getSelectedFile().getCanonicalPath(), true);
            }
            catch (Exception exception) {
                IO.err.println("SDialog.getEntriesFromFile() failed: " + exception);
            }
        }
        return stringArray;
    }

    private static void createAndShowGUI(String[] stringArray) {
        Universe universe;
        Object object;
        String string;
        String string2;
        if (stringArray == null) {
            string2 = "select.txt";
            string = null;
        } else if (stringArray.length == 1) {
            string2 = stringArray[0];
            string = null;
        } else if (stringArray.length == 2) {
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            return;
        }
        JFrame jFrame = new JFrame("SDialog test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setPreferredSize(new Dimension(100, 100));
        Object[] objectArray = IO.file2Array(string2, true);
        SDialog sDialog = new SDialog((Frame)jFrame, true);
        if (string != null) {
            object = IO.file2Array(string, true);
            universe = new Universe((String[])objectArray, (String[])object);
        } else if (string2.equals("select.txt")) {
            object = new Quaternary();
            String[] stringArray2 = new String[]{"         ", " (both)  ", " (up)    ", " (dn)    "};
            ((StateSpace)object).setNames(stringArray2);
            universe = new Universe(objectArray, (StateSpace)object);
        } else {
            universe = new Universe(objectArray);
        }
        sDialog.setUniverse(universe);
        sDialog.addTab("Lexical");
        jFrame.pack();
        jFrame.setVisible(true);
        sDialog.setVisible(true);
        object = sDialog.getStrings();
        IO.err.println("SDialog.main: chosen= " + sDialog.chosen + " picked = " + object);
        if (object != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                IO.err.println("\tpicked[" + i + "] = " + (String)object[i]);
            }
        }
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SDialog.createAndShowGUI(stringArray);
            }
        });
    }
}

