/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.subset.SComboBoxModel;
import g2d.subset.SComboBoxRenderer;
import g2d.subset.SEditorPane;
import g2d.subset.SEvent;
import g2d.subset.Universe;
import g2d.subset.Urelement;
import g2d.util.IO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;

public class SComboBox
extends JComboBox<Object> {
    private JTextComponent editor;
    private Universe universe;
    private boolean debug = false;
    private SComboBoxModel model = new SComboBoxModel();
    private static final boolean macOSX = SComboBox.isMacOSX();
    public static final int Linux = 0;
    public static final int MacOSX = 1;

    public SComboBox(Universe universe) {
        this.setModel(this.model);
        this.model.addAll(universe.universe);
        this.universe = universe;
        this.setEditable(true);
        this.setRenderer(new SComboBoxRenderer());
        this.addActionListener(new SComboBoxActionListener());
        this.setSelectedIndex(-1);
        this.init();
    }

    private static final boolean isMacOSX() {
        String string = System.getProperty("os.name");
        if (string.equals("Mac OS X")) {
            return true;
        }
        if (string.equals("Linux")) {
            return false;
        }
        return false;
    }

    private void init() {
        try {
            Component component = this.getEditor().getEditorComponent();
            this.editor = (JTextComponent)component;
        }
        catch (ClassCastException classCastException) {
            IO.err.println("Autocompletion OFF! " + classCastException.getMessage());
        }
        if (this.editor != null) {
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    String string = SComboBox.this.editor.getText();
                    SComboBox.this.showChoices(string, keyEvent);
                }
            });
        }
    }

    public static void debugPLAF() {
        JComboBox jComboBox = new JComboBox();
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component != null) {
            Class<?> clazz = component.getClass();
            IO.err.println(clazz);
            Class<?> clazz2 = clazz;
            int n = 0;
            while ((clazz2 = clazz2.getSuperclass()) != null) {
                IO.err.println("super[" + n + "]: " + clazz2);
                ++n;
            }
            Class<?>[] classArray = clazz.getClasses();
            for (int i = 0; i < classArray.length; ++i) {
                IO.err.println("ecs[" + i + "] = " + classArray[i]);
            }
        } else {
            IO.err.println("ed is null");
        }
    }

    private void next(Object object) {
        if (object != null && object instanceof Urelement) {
            Urelement urelement = (Urelement)object;
            if (urelement.isSelected() || !urelement.isDisabled()) {
                urelement.nextState();
            }
            this.universe.fireSEvent(new SEvent(urelement));
        }
    }

    private void showChoices(String string, KeyEvent keyEvent) {
        int n = string.length();
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (n2 == 40 || n2 == 38) {
            return;
        }
        if (n2 == 10) {
            this.next(this.getSelectedItem());
            return;
        }
        if (this.debug) {
            IO.err.println("editor: " + string + " of length = " + string.length());
        }
        if (n == 0) {
            if (n2 == 127 || n2 == 8 || c == '\uffff') {
                if (this.debug) {
                    IO.err.println("editor: beep! (c = '" + c + "')");
                }
                this.showItems(this.universe.universe);
                return;
            }
            if (this.debug) {
                IO.err.println("editor: " + c);
            }
            c = Character.toUpperCase(c);
            this.showItems("" + c);
        } else {
            String string2 = string;
            if (n2 == 127) {
                this.editor.cut();
                string2 = string = this.editor.getText();
                this.editor.setText(string2);
                this.setPopupVisible(false);
                return;
            }
            if (n2 == 8) {
                String string3 = this.editor.getSelectedText();
                if (string3 == null) {
                    string = string.substring(0, n - 1);
                } else {
                    this.editor.cut();
                    string2 = string = this.editor.getText();
                    keyEvent.consume();
                }
                this.setPopupVisible(false);
                return;
            }
            string = string + c;
            if (this.debug) {
                IO.err.println("new current: " + string);
            }
            this.showItems(string);
            this.editor.setText(string2);
        }
    }

    public void reset(ArrayList<Urelement> arrayList) {
        int n = arrayList.size();
        SComboBoxModel sComboBoxModel = new SComboBoxModel();
        sComboBoxModel.addAll(arrayList);
        this.setModel(this.model);
        if (n > 0) {
            sComboBoxModel.addAll(arrayList);
            if (macOSX) {
                for (int i = n; i <= this.getMaximumRowCount(); ++i) {
                    sComboBoxModel.addElement(new Urelement("", -1, this.universe));
                }
            }
        }
        this.setModel(sComboBoxModel);
        this.setSelectedIndex(-1);
    }

    public void _reset(ArrayList<Urelement> arrayList) {
        this.removeAllItems();
        int n = arrayList.size();
        if (n > 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.addItem(arrayList.get(n2));
            }
            if (macOSX) {
                for (n2 = n; n2 <= this.getMaximumRowCount(); ++n2) {
                    this.addItem(new Urelement("", -1, this.universe));
                }
            }
            this.setSelectedIndex(-1);
        }
    }

    private void showItems(String string) {
        this.showItems(this.universe.beginsWith(string));
    }

    private void showItems(ArrayList<Urelement> arrayList) {
        this.setPopupVisible(false);
        this.reset(arrayList);
        if (arrayList.size() > 0 && this.isDisplayable()) {
            this.setPopupVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        Object[] objectArray = IO.file2Array("select.txt", true);
        Universe universe = new Universe(objectArray);
        SComboBox sComboBox = new SComboBox(universe);
        SEditorPane sEditorPane = new SEditorPane();
        sEditorPane.setUniverse(universe);
        JFrame jFrame = new JFrame("SComboBox");
        jFrame.add((Component)sComboBox, "North");
        jFrame.add((Component)sEditorPane, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setPreferredSize(new Dimension(400, 400));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class SComboBoxActionListener
    implements ActionListener {
        private SComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = SComboBox.this.getSelectedItem();
            int n = actionEvent.getModifiers();
            if (((long)n & 0x10L) != 0L) {
                SComboBox.this.next(object);
            }
        }
    }
}

