/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.subset.Universe;
import g2d.subset.Urelement;
import java.util.ArrayList;
import java.util.TreeMap;

public class Dictionary {
    private TreeMap<Character, ArrayList<Urelement>> index;
    protected Universe universe;

    public Dictionary(Universe universe) {
        this.universe = universe;
        this.index = new TreeMap();
        ArrayList<Urelement> arrayList = universe.universe;
        if (arrayList == null) {
            return;
        }
        for (Urelement urelement : arrayList) {
            this.insert(urelement);
        }
    }

    public boolean insert(Urelement urelement) {
        if (urelement == null) {
            return false;
        }
        String string = urelement.toString();
        Character c = new Character(Character.toUpperCase(string.charAt(0)));
        urelement.classify("Lexical", c.toString());
        ArrayList<Urelement> arrayList = this.index.get(c);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.index.put(c, arrayList);
            arrayList.add(urelement);
        } else {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (urelement.compareTo(arrayList.get(i)) >= 0) continue;
                arrayList.add(i, urelement);
                return true;
            }
            arrayList.add(urelement);
        }
        return true;
    }

    public boolean delete(Urelement urelement) {
        if (urelement == null) {
            return false;
        }
        String string = urelement.toString();
        Character c = new Character(Character.toUpperCase(string.charAt(0)));
        ArrayList<Urelement> arrayList = this.index.get(c);
        if (arrayList == null) {
            return false;
        }
        boolean bl = arrayList.remove(urelement);
        if (arrayList.size() == 0) {
            this.index.remove(c);
        }
        return bl;
    }

    public ArrayList<Urelement> beginsWith(String string) {
        if (string == null || string.length() == 0) {
            return this.universe.universe;
        }
        Character c = new Character(Character.toUpperCase(string.charAt(0)));
        ArrayList<Urelement> arrayList = this.index.get(c);
        ArrayList<Urelement> arrayList2 = new ArrayList<Urelement>();
        if (arrayList == null) {
            return arrayList2;
        }
        string = string.toLowerCase();
        for (int i = 0; i < arrayList.size(); ++i) {
            Urelement urelement = arrayList.get(i);
            String string2 = urelement.toString().toLowerCase();
            if (!string2.startsWith(string)) continue;
            arrayList2.add(urelement);
        }
        return arrayList2;
    }
}

