/*
 * Decompiled with CFR 0.152.
 */
package g2d.runtime;

import g2d.jlambda.Handler;
import g2d.util.ActorMsg;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;

public class ExceptionHandler
implements Handler {
    private static Logger logger = Logger.getLogger("iop.runtime.ExceptionHandler");
    String logFileName;
    public static boolean SHUTDOWN_AFTER_ERROR = true;

    public ExceptionHandler() {
        String string = System.getProperty("user.home", ".");
        String string2 = System.getProperty("file.separator", "/");
        this.logFileName = string + string2 + ".iop.log";
        try {
            FileHandler fileHandler = new FileHandler(this.logFileName);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
            logger.setLevel(Level.ALL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void handle(Throwable throwable) {
        logger.log(Level.SEVERE, "Unrecoverable Error", throwable);
        JOptionPane.showMessageDialog(null, "An uncaught exception has occurred.\nDetails have been written to a log file\n(" + this.logFileName + ")." + (SHUTDOWN_AFTER_ERROR ? "\n\nClick 'OK' to shut down." : ""), "Unexpected Error", 0);
        if (SHUTDOWN_AFTER_ERROR) {
            ActorMsg.send("system", "graphics2d", "stop system");
        }
    }
}

