/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.GraphItem;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.jlambda.Closure;
import g2d.jlambda.Interpreter;
import g2d.pla.GraphItemRenderer;
import g2d.pla.PLAPanel;
import g2d.pla.PLAUtils;
import g2d.swing.IOPAskUser;
import g2d.tabwin.TabFrame;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SubgraphTabita
extends JPanel
implements ChangeListener {
    private static final String jlambdaSubgraph2Node = "subgraph2Node";
    private final PLAPanel owner;
    private final JComboBox<String> modusOperandi;
    private final JComboBox<SubgraphAction> actionChooser;
    private final JLabel status = new JLabel();
    private final JPanel north = new JPanel(new BorderLayout());
    private final JPanel south = new JPanel(new BorderLayout());
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel center = new JPanel(this.cardLayout);
    private final SubgraphPanel[] subgraphPanels = new SubgraphPanel[SubgraphMode.values().length];
    private final ActionListener chooseAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private final ActionListener createAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
            Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
            ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>();
            for (GraphItem graphItem : collection) {
                if (!graphItem.isSelected()) continue;
                arrayList.add(graphItem);
            }
            if (arrayList.size() > 0) {
                SubgraphTabita.this.resetAll();
                IOPSubgraph iOPSubgraph = iOPGraph.makeSubgraph(arrayList);
                SubgraphTabita.this.addSubgraph(iOPSubgraph);
                SubgraphMode.SUBGRAPHS.toggle(iOPGraph, iOPSubgraph, true, false);
            } else {
                SubgraphTabita.this.status.setText("A subgraph cannot be empty");
            }
        }
    };
    private final ActionListener deleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
            Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
            ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>();
            for (GraphItem graphItem : collection) {
                if (!graphItem.isSelected()) continue;
                arrayList.add(graphItem);
            }
            if (arrayList.size() == 1) {
                GraphItem graphItem = (GraphItem)arrayList.get(0);
                SubgraphTabita.this.resetAll();
                if (graphItem instanceof IOPSubgraph) {
                    SubgraphTabita.this.deleteSubgraph((IOPSubgraph)graphItem);
                } else {
                    SubgraphTabita.this.status.setText("Can only delete subgraphs");
                }
            } else {
                SubgraphTabita.this.status.setText("Need to select a unique subgraph to delete");
            }
        }
    };
    private final ActionListener collapse2OccAction = this.makeCollapser(IOPNode.NodeType.OCC, "Name your new occurrence");
    private final ActionListener collapse2RuleAction = this.makeCollapser(IOPNode.NodeType.RULE, "Name your new rule");
    private final ActionListener undoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
            Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
            ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>();
            for (GraphItem object : collection) {
                if (!object.isSelected()) continue;
                arrayList.add(object);
            }
            if (arrayList.size() == 1) {
                GraphItem graphItem = (GraphItem)arrayList.get(0);
                SubgraphTabita.this.resetAll();
                if (graphItem instanceof IOPSubgraph) {
                    List<IOPNode> list = ((IOPSubgraph)graphItem).getNodes(iOPGraph);
                    SubgraphTabita.this.deleteSubgraph((IOPSubgraph)graphItem);
                    for (IOPNode iOPNode : list) {
                        SubgraphMode.SUBGRAPHS.toggle(iOPGraph, iOPNode, true, false);
                    }
                } else {
                    SubgraphTabita.this.status.setText("Can only undo subgraphs");
                }
            } else {
                SubgraphTabita.this.status.setText("Need to select a subgraph to undo");
            }
        }
    };
    private final ActionListener expandAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
            Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
            ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>();
            for (GraphItem graphItem : collection) {
                if (!graphItem.isSelected()) continue;
                arrayList.add(graphItem);
            }
            if (arrayList.size() == 1) {
                GraphItem graphItem = (GraphItem)arrayList.get(0);
                SubgraphTabita.this.resetAll();
                if (graphItem instanceof IOPNode) {
                    SubgraphTabita.this.expandNode((IOPNode)graphItem);
                } else {
                    SubgraphTabita.this.status.setText("Can only expand nodes");
                }
            } else {
                SubgraphTabita.this.status.setText("Need to select a unique node to collapse");
            }
        }
    };
    private final ActionListener resetAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SubgraphTabita.this.resetAll();
        }
    };
    private final ActionListener[] actions = new ActionListener[]{this.chooseAction, this.createAction, this.deleteAction, this.collapse2OccAction, this.collapse2RuleAction, this.expandAction, this.undoAction, this.resetAction};

    public SubgraphTabita(PLAPanel pLAPanel, Font font) {
        super(new BorderLayout());
        this.owner = pLAPanel;
        this.modusOperandi = this.makeModusOperandi();
        for (SubgraphAction enum_ : SubgraphAction.values()) {
            enum_.action = this.actions[enum_.index];
        }
        this.actionChooser = this.makeActionChooser();
        this.south.add(this.actionChooser, "Center");
        this.north.add((Component)this.status, "Center");
        this.north.add(this.modusOperandi, "South");
        this.add((Component)this.north, "North");
        this.add((Component)this.south, "South");
        for (Enum enum_ : SubgraphMode.values()) {
            SubgraphPanel subgraphPanel;
            this.subgraphPanels[enum_.ordinal()] = subgraphPanel = new SubgraphPanel((SubgraphMode)enum_);
            this.center.add((Component)subgraphPanel, ((SubgraphMode)enum_).header);
        }
        this.add((Component)this.center, "Center");
    }

    public void populate(List<IOPNode> list, List<IOPNode> list2, Collection<GraphItem> collection) {
        if (list == null || list2 == null || collection == null) {
            return;
        }
        block5: for (SubgraphMode subgraphMode : SubgraphMode.values()) {
            SubgraphPanel subgraphPanel = this.subgraphPanels[subgraphMode.ordinal()];
            switch (subgraphMode) {
                case OCCURRENCES: {
                    subgraphPanel.addIOPNodes(list);
                    continue block5;
                }
                case RULES: {
                    subgraphPanel.addIOPNodes(list2);
                    continue block5;
                }
                case SUBGRAPHS: {
                    subgraphPanel.addGraphItems(collection);
                }
            }
        }
    }

    public void addSubgraph(IOPSubgraph iOPSubgraph) {
        IOPGraph iOPGraph = this.owner.getGraph();
        iOPGraph.addSubgraph(iOPSubgraph);
        iOPGraph.doLayout();
        this.owner.setGraph(iOPGraph);
    }

    public void deleteSubgraph(IOPSubgraph iOPSubgraph) {
        IOPGraph iOPGraph = this.owner.getGraph();
        iOPGraph.delete(iOPSubgraph);
        iOPGraph.doLayout();
        this.owner.setGraph(iOPGraph);
    }

    public void collapseSubgraph(IOPSubgraph iOPSubgraph, IOPNode.NodeType nodeType, String string) {
        IOPGraph iOPGraph = this.owner.getGraph();
        IOPNode iOPNode = this.subgraph2Node(iOPGraph, iOPSubgraph, nodeType, string);
        if (iOPNode != null) {
            iOPGraph.contract(iOPSubgraph, iOPNode);
            iOPGraph.doLayout();
            this.owner.setGraph(iOPGraph);
        } else {
            this.status.setText("The subgraph2Node method returnen null. Giving up.");
        }
    }

    public void expandNode(IOPNode iOPNode) {
        IOPGraph iOPGraph = this.owner.getGraph();
        iOPGraph.expand(iOPNode);
        iOPGraph.doLayout();
        this.owner.setGraph(iOPGraph);
    }

    private IOPNode subgraph2Node(IOPGraph iOPGraph, IOPSubgraph iOPSubgraph, IOPNode.NodeType nodeType, String string) {
        IOPNode iOPNode = null;
        Interpreter interpreter = Interpreter.getInterpreter("default");
        try {
            Object object;
            Object object2 = interpreter.globalLookup(jlambdaSubgraph2Node);
            if (object2 instanceof Closure && (object = ((Closure)object2).applyClosure(iOPGraph, nodeType == IOPNode.NodeType.OCC ? "occ" : "rule", string)) instanceof IOPNode) {
                iOPNode = (IOPNode)object;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return iOPNode;
    }

    private JComboBox<SubgraphAction> makeActionChooser() {
        final JComboBox<SubgraphAction> jComboBox = new JComboBox<SubgraphAction>();
        jComboBox.setOpaque(false);
        for (SubgraphAction subgraphAction : SubgraphAction.values()) {
            jComboBox.addItem(subgraphAction);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SubgraphAction subgraphAction;
                if (itemEvent.getStateChange() == 1 && (subgraphAction = (SubgraphAction)((Object)itemEvent.getItem())) != SubgraphAction.CHOOSE) {
                    subgraphAction.action.actionPerformed(null);
                    jComboBox.setSelectedIndex(0);
                }
            }
        });
        return jComboBox;
    }

    private JComboBox<String> makeModusOperandi() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setOpaque(false);
        for (SubgraphMode subgraphMode : SubgraphMode.values()) {
            jComboBox.addItem(subgraphMode.header);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SubgraphTabita.this.cardLayout.show(SubgraphTabita.this.center, (String)itemEvent.getItem());
                }
            }
        });
        return jComboBox;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private ActionListener makeCollapser(final IOPNode.NodeType nodeType, final String string) {
        assert (nodeType != null);
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
                Collection<GraphItem> collection = iOPGraph.getGraphItemsInCollection();
                ArrayList<GraphItem> arrayList = new ArrayList<GraphItem>();
                for (GraphItem object : collection) {
                    if (!object.isSelected()) continue;
                    arrayList.add(object);
                }
                if (arrayList.size() == 1) {
                    GraphItem graphItem = (GraphItem)arrayList.get(0);
                    SubgraphTabita.this.resetAll();
                    if (graphItem instanceof IOPSubgraph) {
                        TabFrame tabFrame = PLAUtils.getTabFrame(iOPGraph);
                        IOPAskUser iOPAskUser = new IOPAskUser((Frame)tabFrame, string, "A unique moniker: ", true);
                        iOPAskUser.setVisible(true);
                        String string2 = iOPAskUser.getAnswer();
                        string2 = string2.trim();
                        if (string2.isEmpty()) {
                            SubgraphTabita.this.status.setText("Cannot collapse without a name for the new node, sorry");
                        } else {
                            SubgraphTabita.this.collapseSubgraph((IOPSubgraph)graphItem, nodeType, string2);
                        }
                    } else {
                        SubgraphTabita.this.status.setText("Can only collapse subgraphs");
                    }
                } else {
                    SubgraphTabita.this.status.setText("Need to select a unique subgraph to collapse");
                }
            }
        };
    }

    public void resetAll() {
        this.owner.resetAllSelections();
        this.status.setText("");
    }

    class SubgraphTableModel
    extends AbstractTableModel {
        private final SubgraphTable table;
        private final SubgraphMode mode;
        private final List<GraphItem> elements = new ArrayList<GraphItem>();

        SubgraphTableModel(SubgraphMode subgraphMode, SubgraphTable subgraphTable) {
            this.mode = subgraphMode;
            this.table = subgraphTable;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Selected";
            }
            return ((SubgraphTable)this.table).mode.label;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return GraphItem.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.mode.isSelected(SubgraphTabita.this.owner.getGraph(), this.elements.get(n));
            }
            return this.elements.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                GraphItem graphItem = this.elements.get(n);
                graphItem.setSelected((Boolean)object);
                boolean bl = graphItem.isSelected();
                if (SubgraphTabita.this.owner != null) {
                    IOPGraph iOPGraph = SubgraphTabita.this.owner.getGraph();
                    this.mode.toggle(iOPGraph, graphItem, bl, false);
                }
                this.fireTableCellUpdated(n, n2);
                ((SubgraphTabita)SubgraphTabita.this).owner.graphPanel.repaint();
            }
        }
    }

    class SubgraphTable
    extends JTable {
        private final SubgraphMode mode;
        protected final SubgraphTableModel model;
        private final TableColumnModel columnModel;

        SubgraphTable(SubgraphMode subgraphMode, PLAPanel pLAPanel) {
            this.mode = subgraphMode;
            this.model = new SubgraphTableModel(this.mode, this);
            this.setModel(this.model);
            this.columnModel = this.getColumnModel();
            this.getTableHeader().setReorderingAllowed(false);
            this.setColumnSizes();
            this.setSelectionMode(0);
            this.setDefaultRenderer(GraphItem.class, new GraphItemRenderer());
            this.setCellSelectionEnabled(true);
        }

        private void setColumnSizes() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMaxWidth(50);
            tableColumn.setResizable(false);
            this.columnModel.getColumn(1).setPreferredWidth(100);
        }
    }

    class SubgraphPanel
    extends JPanel {
        private final JPanel north;
        private final JPanel south;
        private final SubgraphTable table;

        SubgraphPanel(SubgraphMode subgraphMode) {
            super(new BorderLayout());
            this.north = new JPanel();
            this.south = new JPanel();
            this.table = new SubgraphTable(subgraphMode, SubgraphTabita.this.owner);
            this.add((Component)new JScrollPane(this.table), "Center");
            this.add((Component)this.south, "South");
            this.add((Component)this.north, "North");
        }

        protected void addGraphItems(Collection<GraphItem> collection) {
            SubgraphTableModel subgraphTableModel = this.table.model;
            subgraphTableModel.elements.clear();
            for (GraphItem graphItem : collection) {
                IOPNode iOPNode;
                if (graphItem instanceof IOPNode && "true".equals((iOPNode = (IOPNode)graphItem).getAttribute("context"))) continue;
                subgraphTableModel.elements.add(graphItem);
            }
            subgraphTableModel.fireTableDataChanged();
        }

        protected void addIOPNodes(List<IOPNode> list) {
            SubgraphTableModel subgraphTableModel = this.table.model;
            subgraphTableModel.elements.clear();
            for (IOPNode iOPNode : list) {
                if ("true".equals(iOPNode.getAttribute("context"))) continue;
                subgraphTableModel.elements.add(iOPNode);
            }
            subgraphTableModel.fireTableDataChanged();
        }
    }

    public static enum SubgraphAction {
        CHOOSE(0, "Choose Action", "Choose the action you wish to execute"),
        CREATE(1, "Create Subgraph", "Create a subgraph containing the selections."),
        DELETE(2, "Delete Subgraph", "Delete the selected subgraph."),
        COLLAPSE2OCC(3, "Collapse Subgraph to Occurence", "Collapse the selected subgraph to an occurence node."),
        COLLAPSE2RULE(4, "Collapse Subgraph to Rule", "Collapse the selected subgraph to a rule node."),
        EXPAND(5, "Expand Node", "Expand a node that is a collapsed subgraph, back to the subgraph."),
        UNDO(6, "Undo", "Delete subgraph but select nodes"),
        RESET(7, "Reset", "Reset any selections made");

        public final int index;
        public final String label;
        public final String tooltip;
        public ActionListener action;

        private SubgraphAction(int n2, String string2, String string3) {
            this.index = n2;
            this.label = string2;
            this.tooltip = string3;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum SubgraphMode {
        OCCURRENCES("Choose Occurrences", "Occurrences"),
        RULES("Choose Rules", "Rules"),
        SUBGRAPHS("Choose Subgraphs", "Subgraphs");

        public final String header;
        public final String label;

        private SubgraphMode(String string2, String string3) {
            this.header = string2;
            this.label = string3;
        }

        public void toggle(IOPGraph iOPGraph, GraphItem graphItem, boolean bl, boolean bl2) {
            if (graphItem != null) {
                graphItem.setSelected(bl);
                if (graphItem instanceof IOPNode) {
                    IOPNode iOPNode = (IOPNode)graphItem;
                    iOPNode.setAttribute("status", bl ? "subgraph" : "none");
                    iOPNode.updateFillColor();
                } else if (bl) {
                    graphItem.highlight();
                } else {
                    graphItem.dehighlight();
                }
                if (!bl2) {
                    iOPGraph.fireChange(graphItem);
                }
            }
        }

        public boolean isSelected(IOPGraph iOPGraph, GraphItem graphItem) {
            return graphItem.isSelected();
        }
    }
}

