/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.IOPNodeRenderer;
import g2d.pla.PLAPanel;
import g2d.pla.SettingsMode;
import g2d.swing.BulkInputDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SettingsTabita
extends JPanel
implements ChangeListener {
    private PLAPanel owner;
    private JComboBox<String> modusOperandi;
    private JButton reset;
    private JPanel south = new JPanel();
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel center = new JPanel(this.cardLayout);
    private final SettingPanel[] settingPanels = new SettingPanel[SettingsMode.values().length];

    public SettingsTabita(PLAPanel pLAPanel, Font font) {
        super(new BorderLayout());
        this.owner = pLAPanel;
        this.modusOperandi = this.makeModusOperandi();
        this.add(this.modusOperandi, "North");
        this.reset = this.makeReset();
        this.south.add(this.reset);
        this.add((Component)this.south, "South");
        for (SettingsMode settingsMode : SettingsMode.values()) {
            SettingPanel settingPanel;
            this.settingPanels[settingsMode.ordinal()] = settingPanel = new SettingPanel(settingsMode);
            this.center.add((Component)settingPanel, settingsMode.label);
        }
        this.add((Component)this.center, "Center");
    }

    public void setOccsAndRules(List<IOPNode> list, List<IOPNode> list2) {
        if (list == null || list2 == null) {
            return;
        }
        block5: for (SettingsMode settingsMode : SettingsMode.values()) {
            SettingPanel settingPanel = this.settingPanels[settingsMode.ordinal()];
            switch (settingsMode) {
                case GOALS: {
                    settingPanel.populate(list);
                    continue block5;
                }
                case AVOIDS: {
                    settingPanel.populate(list);
                    continue block5;
                }
                case HIDES: {
                    settingPanel.populate(list2);
                }
            }
        }
    }

    private JComboBox<String> makeModusOperandi() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setOpaque(false);
        for (SettingsMode settingsMode : SettingsMode.values()) {
            jComboBox.addItem(settingsMode.label);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SettingsTabita.this.cardLayout.show(SettingsTabita.this.center, (String)itemEvent.getItem());
                }
            }
        });
        return jComboBox;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private JButton makeReset() {
        JButton jButton = new JButton("Reset All Selections");
        jButton.setOpaque(false);
        jButton.setToolTipText("Turn all settings (goals, avoids, etc.) OFF.");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTabita.this.resetAll();
            }
        });
        return jButton;
    }

    public void resetAll() {
        this.owner.resetAllSelections();
    }

    class SettingsTableModel
    extends AbstractTableModel {
        private final SettingsTable table;
        private final SettingsMode mode;
        private final List<IOPNode> elements = new ArrayList<IOPNode>();

        SettingsTableModel(SettingsMode settingsMode, SettingsTable settingsTable) {
            this.mode = settingsMode;
            this.table = settingsTable;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Selected";
            }
            return ((SettingsTable)this.table).mode.header;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return IOPNode.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.mode.isSelected(this.elements.get(n));
            }
            return this.elements.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                IOPNode iOPNode = this.elements.get(n);
                iOPNode.setSelected((Boolean)object);
                boolean bl = iOPNode.isSelected();
                if (SettingsTabita.this.owner != null) {
                    IOPGraph iOPGraph = SettingsTabita.this.owner.getGraph();
                    this.mode.toggle(iOPGraph, iOPNode, bl, false);
                }
                this.fireTableCellUpdated(n, n2);
                ((SettingsTabita)SettingsTabita.this).owner.graphPanel.repaint();
            }
        }
    }

    class SettingsTable
    extends JTable {
        private final SettingsMode mode;
        private final SettingsTableModel model;
        private final TableColumnModel columnModel;

        SettingsTable(SettingsMode settingsMode, PLAPanel pLAPanel) {
            this.mode = settingsMode;
            this.model = new SettingsTableModel(this.mode, this);
            this.setModel(this.model);
            this.columnModel = this.getColumnModel();
            this.getTableHeader().setReorderingAllowed(false);
            this.setColumnSizes();
            this.setSelectionMode(0);
            this.setDefaultRenderer(IOPNode.class, new IOPNodeRenderer());
            this.setCellSelectionEnabled(true);
        }

        private void setColumnSizes() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMaxWidth(50);
            tableColumn.setResizable(false);
            this.columnModel.getColumn(1).setPreferredWidth(100);
        }
    }

    class SettingPanel
    extends JPanel {
        private final JPanel north;
        private final JPanel south;
        private final SettingsTable table;
        private final JButton allOn;
        private final JButton allOff;
        private final JButton inBulk;

        SettingPanel(final SettingsMode settingsMode) {
            super(new BorderLayout());
            this.north = new JPanel();
            this.south = new JPanel();
            this.allOn = new JButton("All On");
            this.allOff = new JButton("All Off");
            this.inBulk = new JButton("In Bulk");
            this.table = new SettingsTable(settingsMode, SettingsTabita.this.owner);
            this.north.add(new JLabel(settingsMode.label));
            this.allOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SettingPanel.this.toggleAll(settingsMode, true);
                }
            });
            this.north.add(this.allOn);
            this.allOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SettingPanel.this.toggleAll(settingsMode, false);
                }
            });
            this.north.add(this.allOff);
            this.north.add(this.inBulk);
            this.inBulk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = BulkInputDialog.showDialog(SettingsTabita.this.owner, settingsMode.label + " in bulk", "Enter a list of " + settingsMode.header.toLowerCase() + " below or read from ", settingsMode.verb + " all " + settingsMode.header.toLowerCase() + " NOT in list above", "raw_text_area");
                    IOPGraph iOPGraph = ((SettingsTabita)SettingsTabita.this).owner.graph;
                    if (iOPGraph != null && stringArray != null && stringArray.length > 0) {
                        boolean bl = BulkInputDialog.isNegated();
                        if (bl) {
                            SettingPanel.this.toggleAll(settingsMode, true);
                        }
                        for (String string : stringArray) {
                            settingsMode.toggle(iOPGraph, iOPGraph.getIOPNode(string), !bl, true);
                        }
                        iOPGraph.fireChange();
                        SettingsTabita.this.owner.repaint();
                    }
                }
            });
            this.add((Component)new JScrollPane(this.table), "Center");
            this.add((Component)this.south, "South");
            this.add((Component)this.north, "North");
        }

        protected void populate(List<IOPNode> list) {
            SettingsTableModel settingsTableModel = this.table.model;
            settingsTableModel.elements.clear();
            for (IOPNode iOPNode : list) {
                if ("true".equals(iOPNode.getAttribute("context"))) continue;
                settingsTableModel.elements.add(iOPNode);
            }
            settingsTableModel.fireTableDataChanged();
        }

        private void toggleAll(SettingsMode settingsMode, boolean bl) {
            IOPGraph iOPGraph = ((SettingsTabita)SettingsTabita.this).owner.graph;
            if (iOPGraph != null) {
                List list = this.table.model.elements;
                for (IOPNode iOPNode : list) {
                    settingsMode.toggle(iOPGraph, iOPNode, bl, true);
                }
                iOPGraph.fireChange();
                SettingsTabita.this.owner.repaint();
            }
        }
    }
}

