/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAPanel;
import g2d.pla.SettingsGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;

public enum SettingsMode {
    GOALS("Set Goals", "Set", "Goals", "long yada yada", "goal", IOPNode.NodeType.OCC),
    AVOIDS("Set Avoids", "Set", "Avoids", "long yada yada", "avoid", IOPNode.NodeType.OCC),
    HIDES("Hide Rules", "Hide", "Rules", "long yada yada", "avoid", IOPNode.NodeType.RULE);

    public final String label;
    public final String verb;
    public final String header;
    public final String description;
    public final String attribute;
    public final IOPNode.NodeType nodeType;

    private SettingsMode(String string2, String string3, String string4, String string5, String string6, IOPNode.NodeType nodeType) {
        this.label = string2;
        this.verb = string3;
        this.header = string4;
        this.description = string5;
        this.attribute = string6;
        this.nodeType = nodeType;
    }

    public void toggle(IOPGraph iOPGraph, IOPNode iOPNode, boolean bl, boolean bl2) {
        if (iOPGraph != null && iOPNode != null) {
            if (iOPNode.type == this.nodeType) {
                iOPNode.setAttribute("status", bl ? this.attribute : "none");
                iOPNode.updateFillColor();
            }
            if (!bl2) {
                iOPGraph.fireChange(iOPNode);
            }
        }
    }

    public boolean isSelected(IOPNode iOPNode) {
        if (iOPNode != null) {
            return iOPNode.getAttributeAsString("status", "none").equals(this.attribute);
        }
        return false;
    }

    public static SettingsGroup settingsList(final PLAPanel pLAPanel, final IOPNode iOPNode) {
        SettingsGroup settingsGroup = new SettingsGroup();
        ButtonGroup buttonGroup = null;
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        IOPNode.NodeType nodeType = iOPNode.type;
        for (SettingsMode settingsMode : SettingsMode.values()) {
            if (nodeType != settingsMode.nodeType) continue;
            arrayList.add(settingsMode.toggler(pLAPanel, iOPNode));
        }
        if (arrayList.size() > 1) {
            buttonGroup = new ButtonGroup();
            JCheckBox jCheckBox = new JCheckBox("Reset to none");
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    iOPNode.setAttribute("status", "none");
                    iOPNode.updateFillColor();
                    pLAPanel.graph.fireChange(iOPNode);
                    pLAPanel.repaint();
                }
            });
            arrayList.add(jCheckBox);
            for (AbstractButton abstractButton : arrayList) {
                buttonGroup.add(abstractButton);
            }
        }
        settingsGroup.buttons = arrayList;
        settingsGroup.group = buttonGroup;
        return settingsGroup;
    }

    private JCheckBox toggler(final PLAPanel pLAPanel, final IOPNode iOPNode) {
        final JCheckBox jCheckBox = new JCheckBox(this.label);
        boolean bl = this.isSelected(iOPNode);
        jCheckBox.setSelected(bl);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsMode.this.toggle(pLAPanel.graph, iOPNode, jCheckBox.isSelected(), false);
                pLAPanel.repaint();
            }
        });
        return jCheckBox;
    }
}

