/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.util.ActorMsg;
import g2d.util.IO;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

public class Sentinel
extends Thread {
    public static final int SLEEP_TIME = 60000;
    public static final int LEEWAY = 5;
    public static final boolean verbose = true;
    private static String logfile = "/tmp/sentinelLog.txt";
    private static DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static HashMap<Integer, Sentinel> watchers = new HashMap();
    private static final String uuid = UUID.randomUUID().toString();
    private static int counter = 0;
    private final int id = counter++;
    private int expected_life_sign = 0;
    private int life_sign = 0;
    private final String self;
    private final String partner;

    public static void watch(String string, String string2) {
        Sentinel sentinel = new Sentinel(string, string2);
        watchers.put(sentinel.id, sentinel);
        Sentinel.log("Sentinel.watch(" + string + ", " + string2 + ")");
    }

    public static void acknowledge(int n, int n2) {
        Sentinel.log("Sentinel.acknowledge(" + n + ", " + n2 + "): ");
        Sentinel sentinel = watchers.get(n);
        if (sentinel != null) {
            if (n2 > sentinel.life_sign) {
                sentinel.life_sign = n2;
            }
            String string = "expected_life_sign = " + sentinel.expected_life_sign + " life_sign = " + n2;
            Sentinel.log(string);
        } else {
            Sentinel.log("\t No Sentinel found!");
        }
    }

    Sentinel(String string, String string2) {
        this.self = string;
        this.partner = string2;
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    if (this.life_sign + 5 < this.expected_life_sign) {
                        Sentinel.log("Sentinel SHUTTING DOWN SYSTEM!!!!");
                        ActorMsg.send("system", this.self, "stop system");
                        continue;
                    }
                    String string = "Sending echo: expected_life_sign = " + this.expected_life_sign + " life_sign = " + this.life_sign;
                    String string2 = "(sinvoke \"g2d.util.ActorMsg\" \"send\" \"" + this.self + "\"\"" + this.partner + "\"(concat \"(sinvoke \\\"g2d.pla.Sentinel\\\"   \\\"acknowledge\\\"  (int " + this.id + ") (int " + this.expected_life_sign + ") )\"))";
                    Sentinel.log(string);
                    ActorMsg.send(this.partner, this.self, string2);
                    ++this.expected_life_sign;
                }
            }
            catch (Exception exception) {
                Sentinel.log(exception.getMessage());
                ++this.expected_life_sign;
                continue;
            }
            break;
        }
    }

    private static void log(String string) {
        Date date = Calendar.getInstance().getTime();
        String string2 = uuid + " " + df.format(date);
        string = string2 + ": " + string;
        IO.string2File(string, logfile, true);
    }
}

