/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.Highlighter;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAUtils;
import g2d.swing.IOPFileChooser;
import g2d.tabwin.TabFrame;
import g2d.util.ActorMsg;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PathTab
extends JPanel {
    private final IOPGraph graph;
    private final Highlighter highlighter;
    private final PathTable table;
    private final PathTableModel model;
    private final JLabel description;
    private final JCheckBox loudness;
    private final JButton launchButton = this.makeLaunchButton();

    public PathTab(IOPGraph iOPGraph) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        this.description = new JLabel();
        this.graph = iOPGraph;
        this.highlighter = Highlighter.getHighlighter(iOPGraph);
        this.loudness = new JCheckBox(new AbstractAction("Loud highlighting"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PathTab.this.highlighter.setLoudness(PathTab.this.loudness.isSelected());
            }
        });
        this.setOpaque(false);
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.model = new PathTableModel();
        this.table = new PathTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        jPanel.add((Component)this.description, "North");
        jPanel.add((Component)this.loudness, "South");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel3.add(this.launchButton);
        jPanel3.add(this.makeSaveButton());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
    }

    public void setPaths(String string, List<List<String>> list) {
        this.highlighter.clear();
        this.model.highlightedPath = -1;
        this.description.setText(string);
        this.model.setPaths(list);
    }

    public void toFile(File file) {
        int n = this.model.paths.size();
        String[] stringArray = new String[n + 1];
        stringArray[0] = this.description.getText();
        for (int i = 0; i < n; ++i) {
            stringArray[i + 1] = this.model.paths.get(i).toString();
        }
        IO.array2File(stringArray, file);
    }

    private JButton makeSaveButton() {
        JButton jButton = new JButton(new SaveAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Save the list to a file");
        return jButton;
    }

    private JButton makeLaunchButton() {
        JButton jButton = new JButton(new LaunchAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Launch selected path");
        jButton.setEnabled(false);
        return jButton;
    }

    class LaunchAction
    extends AbstractAction {
        public LaunchAction() {
            super("Launch");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Path path = PathTab.this.model.getSelectedPath();
            if (path != null) {
                String string = "displayRMP " + path.toMaudeString();
                ActorMsg.send("maude", PathTab.this.graph.getUID(), string);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        private final IOPFileChooser chooser;

        public SaveAction() {
            super("Save");
            this.chooser = new IOPFileChooser("raw_text_area");
            this.chooser.setDialogTitle("Save Paths to File");
            this.chooser.setMultiSelectionEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.situate();
            TabFrame tabFrame = PLAUtils.getTabFrame(PathTab.this.graph);
            int n = this.chooser.showDialog(tabFrame, "Save");
            if (n != 0) {
                return;
            }
            PathTab.this.toFile(this.chooser.getSelectedFile());
        }
    }

    class PathTableModel
    extends AbstractTableModel {
        final String[] headers = new String[]{"Highlight", "Path"};
        List<Path> paths = new ArrayList<Path>();
        int highlightedPath = -1;

        PathTableModel() {
        }

        public Path getSelectedPath() {
            if (this.highlightedPath == -1) {
                return null;
            }
            return this.paths.get(this.highlightedPath);
        }

        public void setPaths(List<List<String>> list) {
            if (list != null) {
                this.paths.clear();
                for (List<String> list2 : list) {
                    Path path = new Path(list2);
                    this.paths.add(path);
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.paths.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.headers[n];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n == this.highlightedPath;
            }
            return this.paths.get(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return Path.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (this.highlightedPath == n) {
                    PathTab.this.highlighter.highlightPath(null);
                    PathTab.this.launchButton.setEnabled(false);
                    this.highlightedPath = -1;
                } else {
                    if (this.highlightedPath != -1) {
                        PathTab.this.highlighter.highlightPath(null);
                    }
                    this.highlightedPath = n;
                    PathTab.this.highlighter.highlightPath(this.paths.get(n));
                    PathTab.this.launchButton.setEnabled(true);
                }
                this.fireTableDataChanged();
            }
        }
    }

    class PathTable
    extends JTable {
        PathTable() {
            this.setModel(PathTab.this.model);
            this.setSelectionMode(0);
            this.setColumnWidths();
        }

        private void setColumnWidths() {
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (i == 0) {
                    tableColumn.setMaxWidth(100);
                    continue;
                }
                tableColumn.setPreferredWidth(400);
            }
        }
    }

    class Path
    extends ArrayList<IOPNode> {
        Path(List<String> list) {
            if (list != null) {
                for (String string : list) {
                    IOPNode iOPNode = PathTab.this.graph.getIOPNode(string);
                    if (iOPNode == null) continue;
                    this.add(iOPNode);
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            boolean bl = true;
            for (IOPNode iOPNode : this) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(iOPNode.getLabel());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public String toMaudeString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (IOPNode iOPNode : this) {
                if (!bl) {
                    stringBuffer.append(" ");
                } else {
                    bl = false;
                }
                stringBuffer.append(iOPNode.longName);
            }
            return stringBuffer.toString();
        }
    }
}

