/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.Highlighter;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAUtils;
import g2d.swing.IOPFileChooser;
import g2d.tabwin.TabFrame;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PairTab
extends JPanel {
    private final IOPGraph graph;
    private final Highlighter highlighter;
    private final PairTable table;
    private final PairTableModel model;
    private final JLabel description;
    private final JCheckBox loudness;

    public PairTab(IOPGraph iOPGraph) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        this.description = new JLabel();
        this.graph = iOPGraph;
        this.highlighter = Highlighter.getHighlighter(iOPGraph);
        this.loudness = new JCheckBox(new AbstractAction("Loud highlighting"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PairTab.this.highlighter.setLoudness(PairTab.this.loudness.isSelected());
            }
        });
        this.setOpaque(false);
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel3.setOpaque(false);
        this.loudness.setSelected(this.highlighter.getLoudness());
        this.setLayout(new BorderLayout());
        this.model = new PairTableModel();
        this.table = new PairTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        jPanel.add((Component)this.description, "North");
        jPanel.add((Component)this.loudness, "South");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel3.add(this.makeSaveButton());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
    }

    public void setPairs(String string, List<String> list) {
        this.highlighter.clear();
        this.model.highlightedPair = -1;
        this.description.setText(string);
        this.model.setPairs(list);
    }

    public void toFile(File file) {
        int n = this.model.pairs.size();
        String[] stringArray = new String[n + 1];
        stringArray[0] = this.description.getText();
        for (int i = 0; i < n; ++i) {
            stringArray[i + 1] = this.model.pairs.get(i).toString();
        }
        IO.array2File(stringArray, file);
    }

    private JButton makeSaveButton() {
        JButton jButton = new JButton(new SaveAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Save the list to a file");
        return jButton;
    }

    class SaveAction
    extends AbstractAction {
        private final IOPFileChooser chooser;

        public SaveAction() {
            super("Save");
            this.chooser = new IOPFileChooser("raw_text_area");
            this.chooser.setDialogTitle("Save Pairs to File");
            this.chooser.setMultiSelectionEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.situate();
            TabFrame tabFrame = PLAUtils.getTabFrame(PairTab.this.graph);
            int n = this.chooser.showDialog(tabFrame, "Save");
            if (n != 0) {
                return;
            }
            PairTab.this.toFile(this.chooser.getSelectedFile());
        }
    }

    class PairTableModel
    extends AbstractTableModel {
        final String[] headers = new String[]{"Highlight", "Pair"};
        List<Pair> pairs = new ArrayList<Pair>();
        int highlightedPair = -1;

        PairTableModel() {
        }

        public void setPairs(List<String> list) {
            if (list != null) {
                int n = list.size();
                this.pairs.clear();
                if (n % 2 == 0) {
                    for (int i = 0; i < n; i += 2) {
                        Pair pair = new Pair(list.get(i), list.get(i + 1));
                        this.pairs.add(pair);
                    }
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.pairs.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.headers[n];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n == this.highlightedPair;
            }
            return this.pairs.get(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return Pair.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (this.highlightedPair == n) {
                    PairTab.this.highlighter.highlightPair(null);
                    this.highlightedPair = -1;
                } else {
                    if (this.highlightedPair != -1) {
                        PairTab.this.highlighter.highlightPair(null);
                    }
                    this.highlightedPair = n;
                    PairTab.this.highlighter.highlightPair(this.pairs.get(n));
                }
                this.fireTableDataChanged();
            }
        }
    }

    class PairTable
    extends JTable {
        PairTable() {
            this.setModel(PairTab.this.model);
            this.setSelectionMode(0);
            this.setColumnWidths();
        }

        private void setColumnWidths() {
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (i == 0) {
                    tableColumn.setMaxWidth(100);
                    continue;
                }
                tableColumn.setPreferredWidth(400);
            }
        }
    }

    class Pair
    extends g2d.util.Pair<IOPNode, IOPNode> {
        Pair(String string, String string2) {
            super(PairTab.this.graph.getIOPNode(string), PairTab.this.graph.getIOPNode(string2));
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[").append(((IOPNode)this.first).getLabel()).append(", ").append(((IOPNode)this.second).getLabel()).append("]");
            return stringBuffer.toString();
        }
    }
}

