/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.GraphItem;
import g2d.graph.IOPEdge;
import g2d.graph.IOPNode;
import g2d.graphviewer.GraphPanel;
import g2d.pla.PLA;
import g2d.pla.PLAPanel;
import g2d.pla.SettingsGroup;
import g2d.pla.SettingsMode;
import g2d.util.ActorMsg;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;

public class PLAGraphPanel
extends GraphPanel {
    PLAPanel owner;

    protected PLAGraphPanel(PLAPanel pLAPanel) {
        this.owner = pLAPanel;
    }

    @Override
    protected JButton makeDisplayButton(String string, int n, IOPNode iOPNode) {
        JButton jButton = this.createMenuButton(string, n);
        final IOPNode iOPNode2 = iOPNode;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLAGraphPanel.this.displayInfo(iOPNode2);
            }
        });
        return jButton;
    }

    protected void displayContextMNode(PLAPanel pLAPanel, IOPNode iOPNode) {
        if (pLAPanel == null) {
            return;
        }
        String string = "";
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        String string2 = iOPNode.longName;
        if (PLA.version < 4) {
            arrayList.add(this.makeDisplayButton("Show Info", 5, iOPNode));
            if (iOPNode.type == IOPNode.NodeType.OCC) {
                string = "Occurrence \"" + string2 + "\"";
                arrayList.add(this.makeG2MaudeButton("About Occurrence", 6, this.graph.getUID(), "displayComponentInfo " + string2 + " " + this.graph.getUID()));
            }
            if (iOPNode.type == IOPNode.NodeType.RULE) {
                string = "Rule \"" + string2 + "\"";
                arrayList.add(this.makeG2MaudeButton("Show Maude Rule", 5, this.graph.getUID(), "display-maude-rule " + string2 + " " + this.graph.getUID()));
                arrayList.add(this.makeG2MaudeButton("Show Evidence", 5, this.graph.getUID(), "displayRuleEvidence " + string2 + " " + this.graph.getUID()));
            }
            SettingsGroup settingsGroup = null;
            if (this.owner.getSEPanel().hasSettings()) {
                settingsGroup = SettingsMode.settingsList(pLAPanel, iOPNode);
                for (AbstractButton abstractButton : settingsGroup.buttons) {
                    arrayList.add(abstractButton);
                }
            }
            if (!arrayList.isEmpty()) {
                ButtonGroup buttonGroup = settingsGroup == null ? null : settingsGroup.group;
                pLAPanel.getSEPanel().displayMenu(string, arrayList, buttonGroup, true);
            }
        } else {
            if (iOPNode.type == IOPNode.NodeType.OCC) {
                string = "Occurrence \"" + string2 + "\"";
            }
            if (iOPNode.type == IOPNode.NodeType.RULE) {
                string = "Rule \"" + string2 + "\"";
            }
            pLAPanel.getSEPanel().displayMenu(string, arrayList, null, true);
        }
    }

    @Override
    public void displayMenu(IOPNode iOPNode) {
        this.displayContextMNode(this.owner, iOPNode);
    }

    @Override
    protected void displayInfo(IOPNode iOPNode) {
        StringBuffer stringBuffer = new StringBuffer("Info:\n");
        stringBuffer.append("  id: " + iOPNode.id + "\n");
        String[] stringArray = iOPNode.getKeys();
        stringBuffer.append("  attributes: " + stringArray.length + "\n");
        for (String string : stringArray) {
            stringBuffer.append("    " + string + " = " + iOPNode.getAttribute(string) + "\n");
        }
        String string = iOPNode.type == IOPNode.NodeType.OCC ? "Occurrence" : "Rule";
        this.owner.getSEPanel().displayText(string + " \"" + iOPNode.longName + "\"", stringBuffer.toString());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent, GraphItem graphItem, Point point) {
        if (mouseEvent != null && mouseEvent.getClickCount() >= 2) {
            IOPNode iOPNode;
            if (PLA.version < 4 && graphItem instanceof IOPNode) {
                iOPNode = (IOPNode)graphItem;
                if (iOPNode.type == IOPNode.NodeType.OCC) {
                    this.displayInfo((IOPNode)graphItem);
                }
                if (iOPNode.type == IOPNode.NodeType.RULE) {
                    ActorMsg.send("maude", this.graph.getUID(), "display-maude-rule " + iOPNode.longName + " " + this.graph.getUID());
                }
            }
            if (graphItem instanceof IOPEdge && (iOPNode = this.calcGotoNode(this.getOccurrence((IOPEdge)graphItem), this.getRule((IOPEdge)graphItem), point, null)) != null) {
                this.centerOn(iOPNode.getBounds().getBounds());
            }
        } else if (graphItem == null) {
            this.displayContextMGraph();
        } else if (graphItem instanceof IOPEdge) {
            this.displayContextMEdge(this.owner, (IOPEdge)graphItem, point);
        } else if (graphItem instanceof IOPNode) {
            this.displayContextMNode(this.owner, (IOPNode)graphItem);
        }
    }

    public IOPNode getOccurrence(IOPEdge iOPEdge) {
        IOPNode iOPNode = iOPEdge.getSource();
        if (iOPNode.type == IOPNode.NodeType.OCC) {
            return iOPNode;
        }
        return iOPEdge.getSink();
    }

    public IOPNode getRule(IOPEdge iOPEdge) {
        IOPNode iOPNode = iOPEdge.getSource();
        if (iOPNode.type == IOPNode.NodeType.RULE) {
            return iOPNode;
        }
        return iOPEdge.getSink();
    }

    public void displayContextMGraph() {
        String string = this.graph.description;
        this.owner.getSEPanel().displayText(this.graph.title, string);
    }

    private void displayContextMEdge(PLAPanel pLAPanel, IOPEdge iOPEdge, Point point) {
        if (pLAPanel == null || iOPEdge == null || this.graph == null) {
            return;
        }
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        IOPNode iOPNode = this.getRule(iOPEdge);
        IOPNode iOPNode2 = this.getOccurrence(iOPEdge);
        String string = iOPNode.longName;
        String string2 = iOPNode2.longName;
        StringBuffer stringBuffer = new StringBuffer();
        IOPNode iOPNode3 = this.calcGotoNode(iOPNode2, iOPNode, point, stringBuffer);
        if (iOPNode3 != null) {
            arrayList.add(this.makeCenterOnButton(stringBuffer.toString(), 0, iOPNode3));
        }
        arrayList.add(this.makeCenterOnButton("Center on Occurrence " + string2, 10, iOPNode2));
        arrayList.add(this.makeCenterOnButton("Center on Rule " + string, 10, iOPNode));
        StringBuffer stringBuffer2 = new StringBuffer("Edge from ");
        stringBuffer2.append(iOPEdge.getSource().longName);
        stringBuffer2.append(" to ");
        stringBuffer2.append(iOPEdge.getSink().longName);
        pLAPanel.getSEPanel().displayMenu(stringBuffer2.toString(), arrayList);
    }

    private IOPNode calcGotoNode(IOPNode iOPNode, IOPNode iOPNode2, Point point, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        boolean bl = this.isGlyphishVisible(iOPNode2);
        boolean bl2 = this.isGlyphishVisible(iOPNode);
        String string = iOPNode2.longName;
        String string2 = iOPNode.longName;
        if (bl && !bl2) {
            stringBuffer.append("Goto Occurence ").append(string2).append(" (off-screen)");
            return iOPNode;
        }
        if (bl2 && !bl) {
            stringBuffer.append("Goto Rule ").append(string).append(" (off-screen)");
            return iOPNode2;
        }
        if (point != null && !(bl ^ bl2)) {
            double d;
            double d2 = iOPNode2.distanceTo(point);
            if (d2 > (d = iOPNode.distanceTo(point))) {
                stringBuffer.append("Goto Rule ").append(string).append(" (further from point clicked)");
                return iOPNode2;
            }
            stringBuffer.append("Goto Occurence ").append(string2).append(" (further from point clicked)");
            return iOPNode;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        this.owner.stateChanged(changeEvent);
    }

    @Override
    protected void checkSize() {
        super.checkSize();
    }
}

