/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.HideEdges;
import g2d.pla.RuleRanks;
import g2d.pla.requestargs.Parser;
import g2d.pla.requestargs.RequestArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PLAGraph {
    public static final String graphAttribute = "PLAGraphAttribute";
    public static boolean VERBOSE = true;
    public final IOPGraph graph;
    public final IOPGraph parent;
    public final List<IOPNode> rules = new ArrayList<IOPNode>();
    public final List<IOPNode> occurrences = new ArrayList<IOPNode>();
    public final Map<String, List<IOPEdge>> occurrencesOut = new HashMap<String, List<IOPEdge>>();
    public final Map<String, List<IOPEdge>> rulesOut = new HashMap<String, List<IOPEdge>>();
    public final List<IOPEdge> bidirectional = new ArrayList<IOPEdge>();
    public List<IOPEdge> hiddenEdges;
    public RuleRanks ruleRanks;
    public RequestArgs requestArgsObj;
    public String requestor;
    public String requestop;
    public String requestargs;

    public static final PLAGraph getPLAGraph(IOPGraph iOPGraph) {
        return iOPGraph != null ? (PLAGraph)iOPGraph.getAttribute(graphAttribute) : null;
    }

    public static final PLAGraph getPLAGraph(IOPGraph iOPGraph, IOPGraph iOPGraph2) {
        if (iOPGraph == null) {
            return null;
        }
        PLAGraph pLAGraph = PLAGraph.getPLAGraph(iOPGraph);
        if (pLAGraph != null) {
            return pLAGraph;
        }
        return new PLAGraph(iOPGraph, iOPGraph2);
    }

    private PLAGraph(IOPGraph iOPGraph, IOPGraph iOPGraph2) {
        this.graph = iOPGraph;
        IOPGraph iOPGraph3 = iOPGraph == null ? null : (this.parent = iOPGraph2 == null ? iOPGraph.getParent() : iOPGraph2);
        if (iOPGraph == null) {
            this.hiddenEdges = null;
            this.ruleRanks = null;
        } else {
            this.init();
        }
    }

    public void init() {
        IOPNode[] iOPNodeArray = this.graph.getNodesInArray();
        IOPEdge[] iOPEdgeArray = this.graph.getEdgesInArray();
        for (IOPNode object2 : iOPNodeArray) {
            IOPEdge[] iOPEdgeArray2 = object2.getAttribute("type");
            String string = object2.id;
            if ("occ".equals(iOPEdgeArray2)) {
                this.occurrences.add(object2);
                this.occurrencesOut.put(string, new ArrayList());
                continue;
            }
            if (!"rule".equals(iOPEdgeArray2)) continue;
            this.rules.add(object2);
            this.rulesOut.put(string, new ArrayList());
        }
        for (IOPNode iOPNode : this.occurrences) {
            String string = iOPNode.id;
            List<IOPEdge> list = this.occurrencesOut.get(string);
            for (IOPEdge iOPEdge : iOPEdgeArray) {
                if (iOPEdge.getSource() != iOPNode) continue;
                list.add(iOPEdge);
            }
        }
        for (IOPNode iOPNode : this.rules) {
            String string = iOPNode.id;
            List<IOPEdge> list = this.rulesOut.get(string);
            for (IOPEdge iOPEdge : iOPEdgeArray) {
                if (iOPEdge.getSource() != iOPNode) continue;
                list.add(iOPEdge);
            }
        }
        for (IOPEdge iOPEdge : iOPEdgeArray) {
            if (!"true".equals(iOPEdge.getAttributeAsString("bidir", null))) continue;
            this.bidirectional.add(iOPEdge);
        }
        this.hiddenEdges = HideEdges.getHiddenEdges(this);
        this.graph.setAttribute("hiddenEdges", this.hiddenEdges);
        this.ruleRanks = new RuleRanks(this);
        if (this.ruleRanks.size() > 0) {
            this.graph.setAttribute("hasRanks", Boolean.TRUE);
            this.graph.setAttribute("usingRanks", Boolean.FALSE);
        }
        this.requestor = this.graph.getAttributeAsString("requestor", null);
        this.requestop = this.graph.getAttributeAsString("requestop", null);
        this.requestargs = this.graph.getAttributeAsString("requestargs", null);
        if (this.requestargs != null) {
            try {
                this.requestArgsObj = Parser.parseFromString(this.requestargs);
                if (VERBOSE) {
                    System.err.println("requestor: " + this.requestor);
                    System.err.println("requestop: " + this.requestop);
                    System.err.println("requestargs: " + this.requestargs);
                    System.err.println("requestArgs object: " + this.requestArgsObj);
                    if (this.requestArgsObj != null) {
                        System.err.println("Focal point: " + this.requestArgsObj.focalPoint(this.graph));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        this.rules.clear();
        this.occurrences.clear();
        this.occurrencesOut.clear();
        this.rulesOut.clear();
        this.bidirectional.clear();
        this.hiddenEdges.clear();
    }

    public void update() {
        this.clear();
        this.init();
    }
}

