/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.TermTable;
import g2d.terms.Term;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TermPanel
extends JPanel {
    public final TermTable table;
    private final JLabel status = new JLabel();
    private final JPanel footer = new JPanel(new BorderLayout(10, 10));
    private final JPanel buttons = new JPanel();
    private final JButton addButton = new JButton();
    private final JButton deleteButton = new JButton();
    private final JCheckBox select = new JCheckBox("Select only");

    public TermPanel(AttackEditor attackEditor, String string, Collection<Term> collection, Term term, boolean bl) {
        super(new BorderLayout(10, 10));
        this.table = new TermTable(attackEditor, string, collection, term, bl);
        this.add((Component)this.status, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.setFillsViewportHeight(true);
        this.addButton.setAction(new AbstractAction("+"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TermPanel.this.add();
            }
        });
        this.deleteButton.setAction(new AbstractAction("-"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TermPanel.this.delete();
            }
        });
        this.select.setAction(new AbstractAction("Select only"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TermPanel.this.setEditable(!TermPanel.this.select.isSelected());
            }
        });
        this.buttons.add(this.select);
        this.buttons.add(this.addButton);
        this.buttons.add(this.deleteButton);
        this.footer.add((Component)this.buttons, "Center");
        this.add((Component)this.footer, "South");
    }

    private void add() {
        this.table.addTerm();
    }

    private void delete() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            this.table.deleteTerm(n);
            this.setStatus("Deleted term " + n, false);
        } else {
            this.setStatus("Need to select a term first", true);
        }
    }

    private void setEditable(boolean bl) {
        this.table.setEditable(bl);
    }

    public void clear() {
        this.table.clear();
    }

    public void setStatus(String string) {
        this.setStatus(string, false);
    }

    public void setStatus(String string, boolean bl) {
        this.status.setText(string);
        this.status.setForeground(bl ? Color.red : Color.black);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        boolean bl = false;
        ArrayList<Term> arrayList = this.table.getTerms();
        for (Term term : arrayList) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(term.toString());
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("empty");
        }
        stringBuffer.append(")");
    }
}

