/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.Role;
import g2d.npa.RoleEditor;
import g2d.npa.RoleTab;
import g2d.util.ActorMsg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class RolePanel
extends JPanel {
    private static final boolean debug = false;
    public final AttackEditor editor;
    private final JTabbedPane roleTabs;
    private final HashMap<String, RoleTab> tabMap = new HashMap();
    private final JPanel footer = new JPanel(new BorderLayout(10, 10));
    private final JPanel buttons = new JPanel();
    private final JComboBox<Actions> actionChooser = new JComboBox<Actions>(Actions.values());

    public RolePanel(AttackEditor attackEditor) {
        super(new BorderLayout(10, 10));
        this.editor = attackEditor;
        this.roleTabs = new JTabbedPane();
        for (Role role : attackEditor.protocol.roles) {
            RoleTab roleTab = new RoleTab(attackEditor, role);
            this.tabMap.put(role.name, roleTab);
            this.roleTabs.add(role.name, roleTab);
        }
        this.add((Component)this.roleTabs, "Center");
        this.footer.add((Component)this.buttons, "East");
        this.actionChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Actions actions = (Actions)((Object)jComboBox.getSelectedItem());
                RolePanel.this.action2action(actions);
            }
        });
        this.buttons.add(this.actionChooser);
        this.add((Component)this.footer, "South");
    }

    private void action2action(Actions actions) {
        switch (actions) {
            case ADD: {
                this.addRole();
                break;
            }
            case CLONE: {
                this.cloneRole();
                break;
            }
            case EDIT: {
                this.editRole();
                break;
            }
            case DELETE: {
                this.deleteRole();
                break;
            }
            case CANCEL: {
                break;
            }
            case NOTHING: {
                break;
            }
            case STRAND: {
                this.addToAttack();
                break;
            }
            case NEVER: {
                this.addToPatterns();
            }
        }
    }

    protected void deleteRole(String string) {
        RoleTab roleTab = this.tabMap.get(string);
        if (roleTab != null) {
            this.roleTabs.remove(roleTab);
            this.tabMap.remove(string);
        }
    }

    protected void addRole(Role role) {
        RoleTab roleTab = this.tabMap.get(role.name);
        if (roleTab != null) {
            this.roleTabs.remove(roleTab);
        }
        roleTab = new RoleTab(this.editor, role);
        this.tabMap.put(role.name, roleTab);
        this.roleTabs.add(role.name, roleTab);
        this.roleTabs.setSelectedComponent(roleTab);
    }

    private void addRole() {
        JDialog jDialog = new JDialog(this.editor, "Role Editor", true);
        RoleEditor roleEditor = new RoleEditor(jDialog, this.editor);
        AttackEditor.npaPreferences.manageJDialog(jDialog, "NPARoleDialog");
        jDialog.getContentPane().add((Component)roleEditor, "Center");
        jDialog.pack();
        jDialog.setVisible(true);
        Role role = roleEditor.getRole();
        if (role != null) {
            this.editor.addRole(role);
            String string = "addRole " + role.toString();
            ActorMsg.send("maude", this.editor.name, string);
        }
    }

    private void editRole() {
        Component component = this.roleTabs.getSelectedComponent();
        if (component instanceof RoleTab) {
            RoleTab roleTab = (RoleTab)component;
            String string = roleTab.role.name;
            JDialog jDialog = new JDialog(this.editor, "Role Editor", true);
            RoleEditor roleEditor = new RoleEditor(jDialog, this.editor, roleTab.role);
            AttackEditor.npaPreferences.manageJDialog(jDialog, "NPARoleDialog");
            jDialog.getContentPane().add((Component)roleEditor, "Center");
            jDialog.pack();
            jDialog.setVisible(true);
            Role role = roleEditor.getRole();
            if (role != null) {
                String string2 = "editRole " + string + " " + role.toString();
                ActorMsg.send("maude", this.editor.name, string2);
            }
        }
    }

    private void cloneRole() {
        Component component = this.roleTabs.getSelectedComponent();
        if (component instanceof RoleTab) {
            RoleTab roleTab = (RoleTab)component;
            Role role = new Role(roleTab.role.name + "clone", roleTab.role);
            String string = "addRole " + role.toString();
            ActorMsg.send("maude", this.editor.name, string);
        }
    }

    private void deleteRole() {
        Component component = this.roleTabs.getSelectedComponent();
        if (component instanceof RoleTab) {
            RoleTab roleTab = (RoleTab)component;
            String string = "deleteRole " + roleTab.role.name;
            ActorMsg.send("maude", this.editor.name, string);
        }
    }

    private void addToAttack() {
        Component component = this.roleTabs.getSelectedComponent();
        if (component instanceof RoleTab) {
            RoleTab roleTab = (RoleTab)component;
            String string = roleTab.role.name;
            this.editor.addRoleToAttack(string, AttackEditor.Tabs.STRANDS);
        }
    }

    private void addToPatterns() {
        Component component = this.roleTabs.getSelectedComponent();
        if (component instanceof RoleTab) {
            RoleTab roleTab = (RoleTab)component;
            String string = roleTab.role.name;
            if (this.editor.neverPatterns.hasSelectedPattern()) {
                this.editor.addRoleToAttack(string, AttackEditor.Tabs.PATTERNS);
            } else {
                String string2 = "To add the role " + string + " to the \"Never Patterns\" tab,\nyou need to create and/or select a particular never pattern.";
                this.editor.setStatus(string2, true);
            }
        }
    }

    public static enum Actions {
        CANCEL(" "),
        ADD("Add new role"),
        CLONE("Clone selected role"),
        EDIT("Edit selected role"),
        DELETE("Delete selected role"),
        NOTHING(" "),
        STRAND("Add selected role to attack table"),
        NEVER("Add selected role to never pattern");

        protected String tt;

        private Actions(String string2) {
            this.tt = string2;
        }

        public String toString() {
            return this.tt;
        }
    }
}

