/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.Role;
import g2d.npa.TermPanel;
import g2d.terms.Algebra;
import g2d.terms.Term;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class RoleEditor
extends JPanel {
    private final Window parent;
    private final AttackEditor editor;
    private final TermPanel termPanel;
    private final JPanel topPanel = new JPanel(new GridLayout(2, 1));
    private final JPanel namePanel = new JPanel();
    private final JLabel nameLabel = new JLabel("Name:");
    private final JTextField nameField = new JTextField(20);
    private final JPanel freshPanel = new JPanel();
    private final JLabel freshLabel = new JLabel("Fresh:");
    private final JTextField freshField = new JTextField(20);
    private final JPanel footer = new JPanel(new BorderLayout(10, 10));
    private final JPanel leftButtons = new JPanel();
    private final JButton okButton = new JButton();
    private boolean okayed = false;
    private final String[] reason = new String[1];

    public RoleEditor(Window window, AttackEditor attackEditor, Role role) {
        super(new BorderLayout(10, 10));
        this.editor = attackEditor;
        this.parent = window;
        this.termPanel = new TermPanel(attackEditor, "Strand", role != null ? role.events : null, this.editor.syntax.strandTemplate, true);
        this.namePanel.add(this.nameLabel);
        this.namePanel.add(this.nameField);
        this.freshPanel.add(this.freshLabel);
        this.freshPanel.add(this.freshField);
        this.topPanel.add(this.namePanel);
        this.topPanel.add(this.freshPanel);
        if (role != null) {
            this.nameField.setText(role.name);
            this.freshField.setText(role.fresh.toString());
        }
        this.add((Component)this.topPanel, "North");
        this.add((Component)new JScrollPane(this.termPanel), "Center");
        this.okButton.setAction(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoleEditor.this.ok();
            }
        });
        this.footer.add((Component)this.leftButtons, "West");
        this.leftButtons.add(this.okButton);
        this.add((Component)this.footer, "South");
    }

    public RoleEditor(Window window, AttackEditor attackEditor) {
        this(window, attackEditor, null);
    }

    public Role getRole() {
        Role role = null;
        if (this.okayed && this.isOK()) {
            Algebra algebra = this.editor.syntax.strandAlgebra;
            String string = this.nameField.getText();
            String string2 = this.freshField.getText();
            String[] stringArray = string2.split("\\s+");
            String[][] stringArray2 = new String[][]{};
            ArrayList<Term> arrayList = this.termPanel.table.getTerms();
            role = new Role(algebra, string, stringArray, arrayList, stringArray2);
        }
        return role;
    }

    private boolean isOK() {
        String string = this.nameField.getText();
        if (string == null || string.trim().equals("")) {
            this.reason[0] = "Please enter a name for your role.";
            return false;
        }
        return this.termPanel.table.isOK(this.reason);
    }

    private void ok() {
        if (this.isOK()) {
            this.okayed = true;
            this.parent.setVisible(false);
        } else {
            this.termPanel.setStatus(this.reason[0], true);
        }
    }
}

