/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.FreshSet;
import g2d.terms.Algebra;
import g2d.terms.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Role {
    public final Algebra algebra;
    public final String name;
    public final FreshSet fresh;
    public final String[][] variables;
    public final HashMap<String, String> typeof;
    public final ArrayList<Term> events;

    protected Role(Algebra algebra, String string, String[] stringArray, ArrayList<Term> arrayList, String[][] stringArray2) {
        if (string == null || stringArray == null || arrayList == null || stringArray2 == null) {
            throw new IllegalArgumentException("Role(...) won't accept null arguments");
        }
        this.name = string;
        this.algebra = algebra;
        this.fresh = new FreshSet(stringArray);
        this.events = new ArrayList();
        this.events.addAll(arrayList);
        this.variables = stringArray2;
        this.typeof = new HashMap();
        this.processVariables();
    }

    public Role(Algebra algebra, String string, String[] stringArray, Object[][] objectArray, String[][] stringArray2) {
        if (algebra == null || string == null || stringArray == null || objectArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("Role(...) won't accept null arguments");
        }
        this.algebra = algebra;
        this.name = string;
        this.fresh = new FreshSet(stringArray);
        this.events = new ArrayList();
        for (Object[] objectArray2 : objectArray) {
            Term term = Term.parseArray(objectArray2, this.algebra);
            if (term == null) continue;
            this.events.add(term);
        }
        this.variables = stringArray2;
        this.typeof = new HashMap();
        this.processVariables();
    }

    protected Role(String string, Role role) {
        this.algebra = role.algebra;
        this.name = string;
        this.fresh = role.fresh;
        this.variables = role.variables;
        this.typeof = role.typeof;
        this.events = new ArrayList<Term>(role.events);
    }

    public static Role parse(Algebra algebra, Object[] objectArray) {
        if (objectArray == null || objectArray.length != 4) {
            throw new IllegalArgumentException("Bad arguments to Role(Object[] roleArray): " + objectArray);
        }
        return Role.parse(algebra, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
    }

    public static Role parse(Algebra algebra, Object object, Object object2, Object object3, Object object4) {
        if (!(object instanceof String && object2 instanceof String[] && object3 instanceof Object[][] && object4 instanceof String[][])) {
            throw new IllegalArgumentException("Bad arguments to parse( ... )");
        }
        return new Role(algebra, (String)object, (String[])object2, (Object[][])object3, (String[][])object4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" ");
        stringBuffer.append("(");
        this.fresh.toStringBuffer(stringBuffer);
        stringBuffer.append(")");
        stringBuffer.append(" ");
        this.events2StringBuffer(stringBuffer);
        stringBuffer.append(" ");
        this.variables2StringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    private void events2StringBuffer(StringBuffer stringBuffer) {
        boolean bl = false;
        stringBuffer.append("(");
        for (Term term : this.events) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(term.toString());
            bl = true;
        }
        if (bl) {
            stringBuffer.append(", ");
        }
        stringBuffer.append("(nil).SMsgList-R");
        stringBuffer.append(")");
    }

    private void variables2StringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        for (Map.Entry<String, String> entry : this.typeof.entrySet()) {
            stringBuffer.append(" ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" : ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
    }

    private void processVariables() {
        for (String[] stringArray : this.variables) {
            String string;
            if (stringArray.length == 2) {
                string = stringArray[0];
                if (this.typeof.get(string) != null) {
                    throw new IllegalArgumentException("Repeated variable argument to Role(...): " + string);
                }
            } else {
                throw new IllegalArgumentException("Bad variables argument to Role(...)");
            }
            this.typeof.put(string, stringArray[1]);
        }
    }
}

