/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.AttackTableModel;
import g2d.npa.FreshSetEditor;
import g2d.npa.HeightEditor;
import g2d.npa.Role;
import g2d.npa.SubstitutionEditor;
import g2d.npa.Tosser;
import java.awt.Color;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class AttackTable
extends JTable {
    private final AttackEditor editor;
    private final AttackTableModel model;
    private final TableColumnModel columnModel;

    public AttackTable(AttackEditor attackEditor) {
        this.editor = attackEditor;
        this.model = new AttackTableModel(attackEditor);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.columnModel = this.getColumnModel();
        this.setColumnSizes();
        this.setShowGrid(true);
        this.setShowHorizontalLines(true);
        this.setShowHorizontalLines(true);
        this.setGridColor(Color.black);
        this.getTableHeader().setReorderingAllowed(false);
    }

    private void setColumnSizes() {
        this.columnModel.getColumn(0).setPreferredWidth(100);
        this.columnModel.getColumn(1).setPreferredWidth(5);
        this.columnModel.getColumn(2).setPreferredWidth(5);
        this.columnModel.getColumn(3).setPreferredWidth(20);
        this.columnModel.getColumn(4).setPreferredWidth(200);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        AbstractCellEditor abstractCellEditor = null;
        if (n2 == 0) {
            abstractCellEditor = new Tosser();
        } else if (n2 == 1) {
            abstractCellEditor = new HeightEditor(0, this.getHeight(n));
        }
        if (n2 == 2) {
            abstractCellEditor = new HeightEditor(this.getBar(n), this.getCeiling(n));
        } else if (n2 == 3) {
            abstractCellEditor = new FreshSetEditor(this.editor, this, this.getRole(n));
        } else if (n2 == 4) {
            abstractCellEditor = new SubstitutionEditor(this.editor, this, this.getRole(n));
        }
        return abstractCellEditor;
    }

    public void addRole(String string) {
        this.model.addRole(string);
    }

    public void removeRole(String string) {
        this.model.removeRole(string);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.model.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public int getBar(int n) {
        return this.model.getBar(n);
    }

    public int getHeight(int n) {
        return this.model.getHeight(n);
    }

    public int getCeiling(int n) {
        return this.model.getCeiling(n);
    }

    public Role getRole(int n) {
        return this.model.getRole(n);
    }

    public void clear() {
        this.model.clear();
    }
}

