/*
 * Decompiled with CFR 0.152.
 */
package g2d.netviewer;

import g2d.graph.GraphItem;
import g2d.graph.IOPNode;
import g2d.graphviewer.GraphPanel;
import g2d.netviewer.NetPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;

public class NetGraphPanel
extends GraphPanel {
    public static boolean debugMouseEvents = false;
    NetPanel owner;

    protected NetGraphPanel(NetPanel netPanel) {
        this.owner = netPanel;
    }

    @Override
    protected JButton makeDisplayButton(String string, int n, IOPNode iOPNode) {
        JButton jButton = this.createMenuButton(string, n);
        final IOPNode iOPNode2 = iOPNode;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetGraphPanel.this.displayInfo(iOPNode2);
            }
        });
        return jButton;
    }

    @Override
    public void displayInfo(IOPNode iOPNode) {
        StringBuffer stringBuffer = new StringBuffer("Info:\n");
        stringBuffer.append("  Id: " + iOPNode.id + "\n");
        String[] stringArray = iOPNode.getKeys();
        stringBuffer.append("  attributes: " + stringArray.length + "\n");
        for (String string : stringArray) {
            stringBuffer.append("    " + string + " = " + iOPNode.getAttribute(string) + "\n");
        }
        String string = iOPNode.type == IOPNode.NodeType.OCC ? "Occurrence" : "Rule";
        this.owner.getSEPanel().displayText(string + " \"" + iOPNode.longName + "\"", stringBuffer.toString());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent, GraphItem graphItem, Point point) {
        if (debugMouseEvents) {
            System.err.println("NetGraphPanel.mouseClicked: " + graphItem);
        }
        if (graphItem != null && this.graph != null && this.graph.mouseClickedClosure != null) {
            this.graph.mouseClickedClosure.applyClosure(graphItem, mouseEvent);
        } else if (debugMouseEvents) {
            if (graphItem == null) {
                System.err.println("Warning: from NetGraphPanel.mouseClicked - no graphItem found");
            }
            if (this.graph.mouseClickedClosure == null) {
                System.err.println("Warning: from NetGraphPanel.mouseClicked - graph has no mouseClickedClosure");
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && this.graph != null && mouseEvent.getClickCount() > 0) {
            Point point = this.transformFromView(mouseEvent.getPoint());
            GraphItem graphItem = this.graph.getGraphItem(point, 10.0);
            this.mouseClicked(mouseEvent, graphItem, point);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        this.owner.stateChanged(changeEvent);
    }
}

