/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda.antlr4.visitor;

import g2d.jlambda.Code;
import g2d.jlambda.SymbolTable;
import g2d.jlambda.antlr4.gen.JLambdaBaseVisitor;
import g2d.jlambda.antlr4.gen.JLambdaParser;
import g2d.jlambda.antlr4.visitor.ParseError;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Visitor
extends JLambdaBaseVisitor<Object> {
    private final String filename;

    private String location(TerminalNode terminalNode) {
        return " @ line  " + terminalNode.getSymbol().getLine() + " of " + this.filename;
    }

    @Override
    public Code visitStringLiteral(JLambdaParser.StringLiteralContext stringLiteralContext) {
        Token token = stringLiteralContext.STRING().getSymbol();
        String string = token.getText();
        int n = token.getLine();
        string = this.dequote(stringLiteralContext.STRING(), string.substring(1, string.length() - 1));
        return Code.cflist("quote", string.intern(), n, this.filename);
    }

    private String dequote(TerminalNode terminalNode, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        block8: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c != '\\') {
                stringBuffer.append(c);
                continue;
            }
            char c2 = cArray[++i];
            switch (c2) {
                case '\"': 
                case '\\': {
                    stringBuffer.append(c2);
                    continue block8;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block8;
                }
                case 't': {
                    stringBuffer.append('\t');
                    continue block8;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    continue block8;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    continue block8;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    continue block8;
                }
                default: {
                    throw new ParseError("Illegal escape character in String: \\" + c2 + this.location(terminalNode));
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String visitIdentifierLiteral(JLambdaParser.IdentifierLiteralContext identifierLiteralContext) {
        return identifierLiteralContext.ID().getSymbol().getText();
    }

    @Override
    public Code visitDefineExpression(JLambdaParser.DefineExpressionContext defineExpressionContext) {
        Token token = defineExpressionContext.ID().getSymbol();
        String string = token.getText();
        int n = token.getLine();
        JLambdaParser.Parameter_listContext parameter_listContext = defineExpressionContext.parameter_list();
        Code code = null;
        if (parameter_listContext != null) {
            code = this.visitParameter_list(defineExpressionContext.parameter_list());
        }
        Object object = this.visitImplictSeq(defineExpressionContext.expression());
        Code code2 = code == null ? Code.cflist("define", string, object, n, this.filename) : Code.cflist("define", string, code, object, n, this.filename);
        return code2;
    }

    @Override
    public Code visitParameter_list(JLambdaParser.Parameter_listContext parameter_listContext) {
        Code code;
        Code code2 = code = new Code();
        for (JLambdaParser.ParameterContext parameterContext : parameter_listContext.parameter()) {
            String string = this.visitParameter(parameterContext);
            code2 = code2.snoc(string);
        }
        return code;
    }

    @Override
    public String visitParameter(JLambdaParser.ParameterContext parameterContext) {
        return parameterContext.ID().getSymbol().getText();
    }

    @Override
    public ArrayList<Object> visitUnit(JLambdaParser.UnitContext unitContext) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<JLambdaParser.ExpressionContext> list = unitContext.expression();
        for (JLambdaParser.ExpressionContext expressionContext : list) {
            arrayList.add(this.visit(expressionContext));
        }
        return arrayList;
    }

    @Override
    public Code visitLambdaExpression(JLambdaParser.LambdaExpressionContext lambdaExpressionContext) {
        int n = lambdaExpressionContext.LAMBDA().getSymbol().getLine();
        Code code = this.visitParameter_list(lambdaExpressionContext.parameter_list());
        Object object = this.visitImplictSeq(lambdaExpressionContext.expression());
        Code code2 = Code.cflist("lambda", code, object, n, this.filename);
        return code2;
    }

    @Override
    public Code visitUnaryExpression(JLambdaParser.UnaryExpressionContext unaryExpressionContext) {
        Token token = unaryExpressionContext.UNARY_OP().getSymbol();
        String string = token.getText();
        String string2 = SymbolTable.canonicalize(string);
        if (string2 == null) {
            throw new ParseError("Unknown operator: " + string + this.location(unaryExpressionContext.UNARY_OP()));
        }
        int n = token.getLine();
        Object t = this.visit(unaryExpressionContext.expression());
        return Code.cflist(string2, t, n, this.filename);
    }

    @Override
    public Code visitBinaryExpression(JLambdaParser.BinaryExpressionContext binaryExpressionContext) {
        return this.visitExpressionList(binaryExpressionContext.BINARY_OP(), binaryExpressionContext.expression());
    }

    @Override
    public Code visitTernaryExpression(JLambdaParser.TernaryExpressionContext ternaryExpressionContext) {
        return this.visitExpressionList(ternaryExpressionContext.TERNARY_OP(), ternaryExpressionContext.expression());
    }

    @Override
    public Code visitTupleExpression(JLambdaParser.TupleExpressionContext tupleExpressionContext) {
        return this.visitExpressionList(tupleExpressionContext.TUPLE(), tupleExpressionContext.expression());
    }

    private Code visitExpressionList(TerminalNode terminalNode, List<JLambdaParser.ExpressionContext> list) {
        if (terminalNode == null) {
            throw new ParseError("visitExpressionList: car cannot be null!");
        }
        Token token = terminalNode.getSymbol();
        String string = token.getText();
        String string2 = SymbolTable.canonicalize(string);
        if (string2 == null) {
            throw new ParseError("Unknown operator: " + string + this.location(terminalNode));
        }
        int n = token.getLine();
        Code code = Code.cflist(string2, n, this.filename);
        Code code2 = (Code)code.cdr();
        for (JLambdaParser.ExpressionContext expressionContext : list) {
            Object t = this.visit(expressionContext);
            code2 = code2.snoc(t);
        }
        return code;
    }

    @Override
    public Code visitOneOrMoreExpression(JLambdaParser.OneOrMoreExpressionContext oneOrMoreExpressionContext) {
        return this.visitExpressionList(oneOrMoreExpressionContext.AMBI1_OP(), oneOrMoreExpressionContext.expression());
    }

    @Override
    public Code visitTwoOrMoreExpression(JLambdaParser.TwoOrMoreExpressionContext twoOrMoreExpressionContext) {
        return this.visitExpressionList(twoOrMoreExpressionContext.AMBI2_OP(), twoOrMoreExpressionContext.expression());
    }

    @Override
    public Code visitNaryExpression(JLambdaParser.NaryExpressionContext naryExpressionContext) {
        return this.visitExpressionList(naryExpressionContext.N_ARY_OP(), naryExpressionContext.expression());
    }

    @Override
    public Code visitInvokeExpression(JLambdaParser.InvokeExpressionContext invokeExpressionContext) {
        return this.visitExpressionList(invokeExpressionContext.INVOKE(), invokeExpressionContext.expression());
    }

    @Override
    public Code visitSinvokeExpression(JLambdaParser.SinvokeExpressionContext sinvokeExpressionContext) {
        return this.visitExpressionList(sinvokeExpressionContext.SINVOKE(), sinvokeExpressionContext.expression());
    }

    @Override
    public Code visitSeqExpression(JLambdaParser.SeqExpressionContext seqExpressionContext) {
        return this.visitExpressionList(seqExpressionContext.SEQ(), seqExpressionContext.expression());
    }

    @Override
    public Code visitApplyExpression(JLambdaParser.ApplyExpressionContext applyExpressionContext) {
        return this.visitExpressionList(applyExpressionContext.APPLY(), applyExpressionContext.expression());
    }

    @Override
    public Code visitDataExpression(JLambdaParser.DataExpressionContext dataExpressionContext) {
        Token token = dataExpressionContext.PRIMITIVE_DATA_OP().getSymbol();
        String string = token.getText();
        String string2 = SymbolTable.canonicalize(string);
        if (string2 == null) {
            throw new ParseError("Unknown operator: " + string + this.location(dataExpressionContext.PRIMITIVE_DATA_OP()));
        }
        int n = token.getLine();
        String string3 = this.visitData(dataExpressionContext.data());
        return Code.cflist(string2, string3, n, this.filename);
    }

    @Override
    public String visitData(JLambdaParser.DataContext dataContext) {
        TerminalNode terminalNode = null;
        if (dataContext.ID() != null) {
            terminalNode = dataContext.ID();
        }
        if (dataContext.CHARACTER() != null) {
            terminalNode = dataContext.CHARACTER();
        }
        if (dataContext.NUMBER() != null) {
            terminalNode = dataContext.NUMBER();
        }
        return terminalNode.getSymbol().getText();
    }

    @Override
    public Code visitForExpression(JLambdaParser.ForExpressionContext forExpressionContext) {
        Token token = forExpressionContext.FOR().getSymbol();
        int n = token.getLine();
        String string = forExpressionContext.ID().getSymbol().getText();
        Object t = this.visit(forExpressionContext.range_expression());
        Object object = this.visitImplictSeq(forExpressionContext.expression());
        return Code.cflist("for", string, t, object, n, this.filename);
    }

    @Override
    public Code visitQuoteExpression(JLambdaParser.QuoteExpressionContext quoteExpressionContext) {
        Token token = quoteExpressionContext.QUOTE().getSymbol();
        int n = token.getLine();
        String string = this.visitString(quoteExpressionContext.string());
        return Code.cflist("quote", string, n, this.filename);
    }

    @Override
    public String visitString(JLambdaParser.StringContext stringContext) {
        TerminalNode terminalNode = null;
        if (stringContext.ID() != null) {
            terminalNode = stringContext.ID();
        }
        if (stringContext.NUMBER() != null) {
            terminalNode = stringContext.NUMBER();
        }
        return terminalNode.getSymbol().getText();
    }

    @Override
    public Code visitMkarrayExpression(JLambdaParser.MkarrayExpressionContext mkarrayExpressionContext) {
        Token token = mkarrayExpressionContext.MKARRAY().getSymbol();
        int n = token.getLine();
        Object t = this.visit(mkarrayExpressionContext.expression());
        String string = this.visitType_expression(mkarrayExpressionContext.type_expression());
        return Code.cflist("mkarray", string, t, n, this.filename);
    }

    @Override
    public Code visitArrayExpression(JLambdaParser.ArrayExpressionContext arrayExpressionContext) {
        Code code;
        Token token = arrayExpressionContext.ARRAY().getSymbol();
        int n = token.getLine();
        String string = this.visitType_expression(arrayExpressionContext.type_expression());
        Code code2 = code = new Code();
        for (JLambdaParser.ExpressionContext expressionContext : arrayExpressionContext.expression()) {
            Object t = this.visit(expressionContext);
            code2 = code2.snoc(t);
        }
        return new Code("array", new Code((Object)string, code), n, this.filename);
    }

    @Override
    public String visitType_expression(JLambdaParser.Type_expressionContext type_expressionContext) {
        TerminalNode terminalNode = null;
        if (type_expressionContext.PRIMITIVE_DATA_OP() != null) {
            terminalNode = type_expressionContext.PRIMITIVE_DATA_OP();
        }
        if (type_expressionContext.ID() != null) {
            terminalNode = type_expressionContext.ID();
        }
        return terminalNode.getSymbol().getText();
    }

    @Override
    public Code visitTryExpression(JLambdaParser.TryExpressionContext tryExpressionContext) {
        Token token = tryExpressionContext.TRY().getSymbol();
        int n = token.getLine();
        Object object = this.visitImplictSeq(tryExpressionContext.expression());
        Code code = this.visitCatchExpression(tryExpressionContext.catch_expression());
        return Code.cflist("try", object, code, n, this.filename);
    }

    private Code visitCatchExpression(JLambdaParser.Catch_expressionContext catch_expressionContext) {
        Token token = catch_expressionContext.CATCH().getSymbol();
        int n = token.getLine();
        String string = this.visitParameter(catch_expressionContext.parameter());
        Object object = this.visitImplictSeq(catch_expressionContext.expression());
        return Code.cflist("catch", string, object, n, this.filename);
    }

    @Override
    public Code visitObjectExpression(JLambdaParser.ObjectExpressionContext objectExpressionContext) {
        Code code;
        Token token = objectExpressionContext.OBJECT().getSymbol();
        int n = token.getLine();
        Code code2 = code = new Code();
        for (JLambdaParser.ExpressionContext expressionContext : objectExpressionContext.expression()) {
            Object t = this.visit(expressionContext);
            code2 = code2.snoc(t);
        }
        Code code3 = Code.cflist("object", code, n, this.filename);
        return code3;
    }

    @Override
    public Code visitNullExpression(JLambdaParser.NullExpressionContext nullExpressionContext) {
        int n = nullExpressionContext.OBJECT().getSymbol().getLine();
        Code code = Code.cflist("object", "null", n, this.filename);
        return code;
    }

    private Object visitImplictSeq(List<JLambdaParser.ExpressionContext> list) {
        ArrayList arrayList = new ArrayList();
        for (JLambdaParser.ExpressionContext expressionContext : list) {
            arrayList.add(this.visit(expressionContext));
        }
        Object object = null;
        object = arrayList.size() > 1 ? Code.collection2Sequence(arrayList, this.filename) : arrayList.get(0);
        return object;
    }

    @Override
    public Code visitLetExpression(JLambdaParser.LetExpressionContext letExpressionContext) {
        int n = letExpressionContext.LET().getSymbol().getLine();
        Code code = this.visitBinding_list(letExpressionContext.binding_list());
        Object object = this.visitImplictSeq(letExpressionContext.expression());
        Code code2 = Code.cflist("let", code, object, n, this.filename);
        return code2;
    }

    @Override
    public Code visitBinding_list(JLambdaParser.Binding_listContext binding_listContext) {
        Code code;
        Code code2 = code = new Code();
        for (JLambdaParser.Binding_pairContext binding_pairContext : binding_listContext.binding_pair()) {
            Code code3 = this.visitBinding_pair(binding_pairContext);
            code2 = code2.snoc(code3);
        }
        return code;
    }

    @Override
    public Code visitBinding_pair(JLambdaParser.Binding_pairContext binding_pairContext) {
        String string = this.visitParameter(binding_pairContext.parameter());
        Object t = this.visit(binding_pairContext.expression());
        return Code.clist(string, t);
    }

    @Override
    public Code visitDoExpression(JLambdaParser.DoExpressionContext doExpressionContext) {
        int n = doExpressionContext.DO().getSymbol().getLine();
        Code code = this.visitDo_binding_list(doExpressionContext.do_binding_list());
        Code code2 = this.visitDo_exit_clause(doExpressionContext.do_exit_clause());
        Code code3 = new Code();
        Code code4 = new Code("do", new Code((Object)code, new Code((Object)code2, code3)), n, this.filename);
        for (JLambdaParser.ExpressionContext expressionContext : doExpressionContext.expression()) {
            Object t = this.visit(expressionContext);
            code3 = code3.snoc(t);
        }
        return code4;
    }

    @Override
    public Code visitDo_binding_list(JLambdaParser.Do_binding_listContext do_binding_listContext) {
        Code code;
        Code code2 = code = new Code();
        for (JLambdaParser.Do_binding_tripleContext do_binding_tripleContext : do_binding_listContext.do_binding_triple()) {
            Code code3 = this.visitDo_binding_triple(do_binding_tripleContext);
            code2 = code2.snoc(code3);
        }
        return code;
    }

    @Override
    public Code visitDo_binding_triple(JLambdaParser.Do_binding_tripleContext do_binding_tripleContext) {
        String string = this.visitParameter(do_binding_tripleContext.parameter());
        Object t = this.visit(do_binding_tripleContext.expression(0));
        Object t2 = this.visit(do_binding_tripleContext.expression(1));
        return Code.clist(string, t, t2);
    }

    @Override
    public Code visitDo_exit_clause(JLambdaParser.Do_exit_clauseContext do_exit_clauseContext) {
        Code code;
        Code code2 = code = new Code();
        for (JLambdaParser.ExpressionContext expressionContext : do_exit_clauseContext.expression()) {
            Object t = this.visit(expressionContext);
            code2 = code2.snoc(t);
        }
        return code;
    }

    public Visitor(String string) {
        this.filename = string;
    }
}

