/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Analyse;
import g2d.jlambda.AnalysisEnv;
import g2d.jlambda.Code;
import g2d.jlambda.Constants;
import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.JarLoad;
import g2d.jlambda.List;
import g2d.jlambda.State;
import g2d.jlambda.SyntaxError;
import g2d.jlambda.antlr4.visitor.Parser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class LoadCont
extends Continuation {
    public LoadCont(List list, String string, List list2, Environment environment, Continuation continuation) {
        this.init(list, string, list2, environment, continuation);
    }

    @Override
    public void cont(State state) {
        state.setTag(0);
        state.setExp(this.args.car());
        state.setEnv(this.env);
    }

    private String libify(Object object) {
        String string = Constants.getBinaryDirectory() + File.separator + "lib" + File.separator;
        String string2 = (String)object;
        File file = new File(string2);
        if (!(file.isAbsolute() || file.exists() || (file = new File(string2 = string + string2)).exists())) {
            string2 = (String)object;
        }
        return string2;
    }

    private void loadJar(String string, State state) {
        File file = new File(string);
        if (!file.exists()) {
            this.msg = this.msg + "jar file not found: " + string;
            this.k.setException(new EvaluateError(this.msg, this.info()));
            state.setTag(2);
            state.setVal(null);
            state.setK(this.k);
        }
        try {
            JarLoad.addFile(file);
            state.setTag(2);
            state.setVal(string);
            state.setK(this.k);
        }
        catch (IOException iOException) {
            this.k.setException(new EvaluateError(iOException.getMessage(), (Throwable)iOException, this.info()));
            state.setTag(2);
            state.setVal(null);
            state.setK(this.k);
        }
    }

    private void loadJLambda(String string, State state) {
        Object object;
        ArrayList arrayList = null;
        Code code = null;
        try {
            arrayList = Parser.parseFromFile(string);
            if (arrayList == null || arrayList.size() == 0) {
                this.msg = this.msg + "file is empty: " + string;
                this.k.setException(new EvaluateError(this.msg, this.info()));
                state.setTag(2);
                state.setVal(null);
                state.setK(this.k);
                return;
            }
            code = Code.collection2Sequence(arrayList, string);
        }
        catch (Exception exception) {
            this.msg = this.msg + "failed on " + string + "\n" + exception.getMessage();
            this.k.setException(new EvaluateError(this.msg, (Throwable)exception, this.info()));
            state.setK(this.k);
            return;
        }
        try {
            object = Analyse.analyse(code, new AnalysisEnv());
        }
        catch (SyntaxError syntaxError) {
            this.k.setException(syntaxError);
            state.setK(this.k);
            return;
        }
        catch (Exception exception) {
            this.msg = this.msg + "analysis failed on " + string;
            this.k.setException(new EvaluateError(this.msg, (Throwable)exception, this.info()));
            state.setK(this.k);
            return;
        }
        state.setTag(0);
        state.setExp(object);
        state.setEnv(new Environment());
        state.setK(this.k);
    }

    @Override
    public void handleReturn(State state) {
        Object object = state.getVal();
        if (!(object instanceof String)) {
            this.msg = this.msg + "arg not String -- " + object;
            this.k.setException(new EvaluateError(this.msg, this.info()));
            state.setK(this.k);
            return;
        }
        String string = this.libify((String)object);
        if (string.endsWith(".jar")) {
            this.loadJar(string, state);
        } else {
            this.loadJLambda(string, state);
        }
    }
}

