/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Analyse;
import g2d.jlambda.AnalysisEnv;
import g2d.jlambda.Attributable;
import g2d.jlambda.Code;
import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.JMap;
import g2d.jlambda.List;
import g2d.jlambda.PrimitiveData;
import g2d.jlambda.State;
import g2d.jlambda.SyntaxError;
import g2d.jlambda.antlr4.visitor.ParseError;
import g2d.jlambda.antlr4.visitor.Parser;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Interpreter {
    public static final boolean DEBUG = false;
    private static final Map<String, Interpreter> namespaces = new JMap().makeMap();
    private final Map<String, Object> definitions = new JMap().makeMap();
    private final Map<String, Object> objects = new JMap().makeMap();
    private final Map<Object, String> uids = new JMap().makeMap();
    private final Map<String, Code> virgins = new JMap().makeMap();
    public final String namespace;

    private Interpreter(String string) {
        this.namespace = string;
        if (namespaces.containsKey(string)) {
            throw new IllegalArgumentException("namespace: " + string + " already in use!");
        }
        namespaces.put(this.namespace, this);
    }

    public static final synchronized Interpreter getInterpreter(String string) {
        Interpreter interpreter = namespaces.get(string);
        if (interpreter != null) {
            return interpreter;
        }
        return new Interpreter(string);
    }

    public static final synchronized String[] getNamespaces() {
        String[] stringArray = new String[namespaces.size()];
        Iterator<Map.Entry<String, Interpreter>> iterator = namespaces.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Interpreter> entry = iterator.next();
            stringArray[n++] = entry.getKey();
        }
        return stringArray;
    }

    public Object evaluateText(String string) throws ParseError, SyntaxError {
        Object object = null;
        object = string.indexOf(40) >= 0 ? this.evaluate(string) : this.evaluate(Parser.parseLiteral(string), new Environment());
        return object;
    }

    public Object evaluate(String string) throws ParseError, SyntaxError {
        String string2 = null;
        return this.evaluate(string, string2);
    }

    public Object evaluate(String string, String string2) throws ParseError, SyntaxError {
        Object object = null;
        ArrayList arrayList = Parser.parseFromString(string, string2);
        for (Object e : arrayList) {
            if (!(e instanceof Code)) continue;
            object = this.evaluate((Code)e);
        }
        return object;
    }

    public Object evaluate(List list) throws SyntaxError {
        Object object = Analyse.analyse(list, new AnalysisEnv());
        return this.evaluate(object, new Environment());
    }

    public Object evaluate(Object object, Environment environment) {
        State state = new State(this);
        state.init(object, environment);
        while (!state.isDone()) {
            state.step();
        }
        return state.getVal();
    }

    public static void dispose(String string) {
        Interpreter interpreter = namespaces.get(string);
        if (interpreter != null) {
            namespaces.remove(string);
            interpreter.reset();
            interpreter = null;
        }
    }

    public void dispose() {
        Interpreter.dispose(this.namespace);
    }

    public void reset() {
        this.definitions.clear();
        this.objects.clear();
        this.uids.clear();
    }

    public synchronized Object globalLookup(String string) {
        Object object = this.definitions.get(string);
        if (object != null) {
            return object;
        }
        return null;
    }

    protected Object evaluateString(String string, Environment environment, Continuation continuation) throws EvaluateError {
        if (Interpreter.isStaticField(string)) {
            return Interpreter.getStaticField(string);
        }
        Object object = this.globalLookup(string);
        if (object == null && !this.definitions.containsKey(string)) {
            String string2 = "unbound variable: " + string;
            throw new EvaluateError(string2, continuation.info());
        }
        return object;
    }

    public synchronized void setUID(Object object, Object object2) throws EvaluateError {
        Object object3 = this.objects.get(object);
        String string = this.uids.get(object2);
        if (string != null) {
            String string2 = "Evaluate.setUID: object " + object2 + " already assigned uid " + string;
            throw new EvaluateError(string2);
        }
        if (object3 != null) {
            String string3 = "Evaluate.setUID: uid " + object + " already bound to " + object3;
            throw new EvaluateError(string3);
        }
        if (!(object instanceof String)) {
            String string4 = "Evaluate.setUID: uid " + object + " is not a string!";
            throw new EvaluateError(string4);
        }
        String string5 = (String)object;
        this.objects.put(string5, object2);
        this.uids.put(object2, string5);
    }

    public synchronized void unsetUID(Object object) {
        if (object != null) {
            String string = this.uids.get(object);
            if (string != null) {
                this.objects.remove(string);
            }
            this.uids.remove(object);
        }
    }

    public synchronized Object getObject(Object object) {
        Object object2 = this.objects.get(object);
        return object2;
    }

    public synchronized String getUID(Object object) {
        String string = this.uids.get(object);
        return string;
    }

    public synchronized void addDefinition(String string, Object object) {
        this.definitions.put(string, object);
    }

    public synchronized void addVirgin(String string, Code code) {
        this.virgins.put(string, code);
    }

    public synchronized Code getVirgin(String string) {
        return this.virgins.get(string);
    }

    public void printDefinitions(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(this.definitions.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            if (bl) {
                Code code = this.getVirgin(string);
                Interpreter._e_(code.prettyPrint());
                continue;
            }
            Interpreter._e_(string);
        }
    }

    protected void printUIDs() {
        Interpreter._e_(this.hashMap2String(this.objects, true));
    }

    public String stringOfUIDs() {
        return this.hashMap2String(this.objects, true);
    }

    public String stringOfDefinitions() {
        return this.hashMap2String(this.definitions, false);
    }

    protected String hashMap2String(Map<?, ?> map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Set<Map.Entry<?, ?>> set = map.entrySet();
        for (Map.Entry<?, ?> entry : set) {
            Object obj = entry.getValue();
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\n <= \n");
            if (bl && obj instanceof Attributable) {
                stringBuffer.append("<attribute map>\n");
                Attributable attributable = (Attributable)obj;
                StringBuffer stringBuffer2 = new StringBuffer();
                attributable.showAttributes(stringBuffer2);
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("</attribute map>\n");
            } else {
                stringBuffer.append(obj);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected Number object2Number(Object object, Continuation continuation) throws EvaluateError {
        if (object instanceof PrimitiveData) {
            object = ((PrimitiveData)object).unwrapValue();
        }
        if (object == null) {
            String string = "object2Number: null arg";
            throw new EvaluateError(string, continuation.info());
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        } else if (!(object instanceof Number)) {
            String string = "object2Number: arg not Number -- " + object;
            throw new EvaluateError(string, continuation.info());
        }
        return (Number)object;
    }

    protected Boolean object2Boolean(Object object, Continuation continuation) throws EvaluateError {
        if (!(object instanceof PrimitiveData)) {
            String string = "object2Boolean: value not PrimitiveData: " + object;
            throw new EvaluateError(string, continuation.info());
        }
        object = ((PrimitiveData)object).unwrapValue();
        if (!(object instanceof Boolean)) {
            String string = "object2Boolean: value not Boolean: " + object;
            throw new EvaluateError(string, continuation.info());
        }
        return (Boolean)object;
    }

    protected static boolean isStaticField(String string) {
        Field field;
        Class<?> clazz;
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        if (n == string.length() - 1) {
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if ("class".equals(string3)) {
            return true;
        }
        if (clazz == null) {
            return false;
        }
        try {
            field = clazz.getField(string3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println(string2 + " doesn't have a field called " + string3);
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        try {
            field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        return true;
    }

    protected static Object getStaticField(String string) {
        Object object;
        Field field;
        Class<?> clazz;
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if ("class".equals(string3)) {
            return clazz;
        }
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getField(string3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        try {
            object = field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        Class<?> clazz2 = field.getType();
        return clazz2.isPrimitive() ? Interpreter.wrap(object) : object;
    }

    protected static PrimitiveData wrap(Object object) {
        assert (object != null);
        return PrimitiveData.wrap(object);
    }

    private static void _e_(String string) {
        System.err.println(string);
    }
}

