/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.List;
import g2d.jlambda.PrimitiveData;
import g2d.jlambda.State;
import g2d.jlambda.Tuple;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

class ForCont
extends Continuation {
    private Iterator<?> iterator;
    private Object body;

    public ForCont(List list, String string, List list2, Environment environment, Continuation continuation) {
        this.init(list, string, list2, environment, continuation);
    }

    @Override
    void cont(State state) {
        state.setTag(0);
        state.setExp(this.args.cadr());
        state.setEnv(this.env);
    }

    @Override
    void handleReturn(State state) {
        ++this.n;
        Object object = state.getVal();
        try {
            if (this.n == 1) {
                if (object == null) {
                    this.setException(state, "target null");
                    return;
                }
                if (this.notArrayOrCollectionOrIterable(object)) {
                    this.setException(state, "target not Array or Collection or Iterable: " + object);
                    return;
                }
                if (this.isEmpty(object)) {
                    this.setReturnState(state, null);
                    return;
                }
                this.iterator = this.getIterator(object);
                this.body = this.args.caddr();
            } else if (!this.iterator.hasNext()) {
                this.setReturnState(state, object);
                return;
            }
            state.setTag(0);
            state.setExp(this.body);
            state.setEnv(this.env.extend(this.iterator.next()));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.setException(state, "concurrent modification of FOR target!");
            return;
        }
    }

    private void setException(State state, String string) {
        this.k.setException(new EvaluateError(string, this.info()));
        this.setReturnState(state, null);
    }

    private void setReturnState(State state, Object object) {
        state.setVal(object);
        state.setK(this.k);
        state.setTag(2);
    }

    private boolean isEmpty(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof String) {
            return ((String)object).length() == 0;
        }
        return (Integer)((PrimitiveData)object).unwrapValue() <= 0;
    }

    private boolean notArrayOrCollectionOrIterable(Object object) {
        return !object.getClass().isArray() && !(object instanceof Collection) && !this.isIterable(object);
    }

    private boolean isIterable(Object object) {
        PrimitiveData primitiveData;
        Object object2;
        if (object instanceof String) {
            return true;
        }
        return object instanceof PrimitiveData && (object2 = (primitiveData = (PrimitiveData)object).unwrapValue()) instanceof Integer;
    }

    private Iterator<?> getIterator(Object object) {
        if (object instanceof Tuple) {
            return ((Tuple)object).iterator();
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        if (object instanceof String) {
            return new StringIterator((String)object);
        }
        return new IntegerIterator((Integer)((PrimitiveData)object).unwrapValue());
    }

    private class StringIterator
    implements Iterator<Object> {
        private final char[] array;
        private final int length;

        public StringIterator(String string) {
            this.array = string.toCharArray();
            this.length = this.array.length;
        }

        @Override
        public boolean hasNext() {
            return ForCont.this.n - 1 < this.length;
        }

        @Override
        public Object next() {
            return PrimitiveData.wrap(Character.valueOf(this.array[ForCont.this.n - 1]));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class IntegerIterator
    implements Iterator<Object> {
        private final int i;

        public IntegerIterator(int n) {
            this.i = n;
        }

        @Override
        public boolean hasNext() {
            return ForCont.this.n - 1 < this.i;
        }

        @Override
        public Object next() {
            return PrimitiveData.wrap(ForCont.this.n - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ArrayIterator
    implements Iterator<Object> {
        private final Object array;
        private final int size;
        private final boolean primitive;

        public ArrayIterator(Object object) {
            this.array = object;
            this.size = Array.getLength(object);
            this.primitive = this.array.getClass().getComponentType().isPrimitive();
        }

        @Override
        public boolean hasNext() {
            return ForCont.this.n <= this.size;
        }

        @Override
        public Object next() {
            return this.primitive ? PrimitiveData.wrap(Array.get(this.array, ForCont.this.n - 1)) : Array.get(this.array, ForCont.this.n - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

