/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.Char;
import g2d.jlambda.Code;
import g2d.jlambda.Continuation;
import g2d.jlambda.Environment;
import g2d.jlambda.EvaluateError;
import g2d.jlambda.Interpreter;
import g2d.jlambda.List;
import g2d.jlambda.PrimitiveData;
import g2d.jlambda.SyntaxError;
import g2d.jlambda.Utils;
import g2d.jlambda.antlr4.visitor.ParseError;
import g2d.jlambda.antlr4.visitor.Parser;
import java.util.ArrayList;

public final class Evaluate {
    public static final boolean DEBUG = false;
    private static final Interpreter engine = Interpreter.getInterpreter("default");

    private Evaluate() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Evaluate._e_("Usage: java g2d/jlambda/Evaluate <filename>");
            return;
        }
        String string = stringArray[0];
        try {
            ArrayList arrayList = Parser.parseFromFile(string);
            for (Object e : arrayList) {
                if (!(e instanceof Code)) continue;
                engine.evaluate((Code)e);
            }
        }
        catch (Exception exception) {
            Evaluate._e_("Evaluate.main uncaught exception\n");
            exception.printStackTrace(System.err);
        }
    }

    public static Object evaluateText(String string) throws ParseError, SyntaxError {
        return engine.evaluateText(string);
    }

    public static Object evaluate(String string) throws ParseError, SyntaxError {
        String string2 = null;
        return engine.evaluate(string, string2);
    }

    public static Object evaluate(String string, String string2) throws ParseError, SyntaxError {
        return engine.evaluate(string, string2);
    }

    public static Object evaluate(List list) throws SyntaxError {
        return engine.evaluate(list);
    }

    public static Object evaluate(Object object, Environment environment) {
        return engine.evaluate(object, environment);
    }

    public static void reset() {
        engine.reset();
    }

    public static Object evaluateString(String string, Environment environment, Continuation continuation) throws EvaluateError {
        return engine.evaluateString(string, environment, continuation);
    }

    public static Object getUID(Object object) {
        return engine.getUID(object);
    }

    public static void setUID(Object object, Object object2) throws EvaluateError {
        engine.setUID(object, object2);
    }

    public static void unsetUID(Object object) {
        engine.unsetUID(object);
    }

    public static Object getObject(Object object) {
        return engine.getObject(object);
    }

    public static void addDefinition(String string, Object object) {
        engine.addDefinition(string, object);
    }

    public static void printDefinitions(boolean bl) {
        engine.printDefinitions(bl);
    }

    public static void printUIDs() {
        engine.printUIDs();
    }

    public static void addVirgin(String string, Code code) {
        engine.addVirgin(string, code);
    }

    public static Code getVirgin(String string) {
        return engine.getVirgin(string);
    }

    public static void showDefinition(String string) {
        String[] stringArray = string.split("\\s");
        if (stringArray.length != 2) {
            Utils.err.println("To see a definition use\n s function_name");
        } else {
            Code code = engine.getVirgin(stringArray[1]);
            if (code == null) {
                Utils.err.println("No such definition, sorry");
            } else {
                Utils.err.println(code.prettyPrint());
            }
        }
    }

    public static Boolean evaluateBoolean(List list, Environment environment) {
        return Boolean.valueOf((String)list.car());
    }

    public static Byte evaluateByte(List list, Environment environment) {
        try {
            return new Byte((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateByte: warning -- " + numberFormatException);
            return new Byte(0);
        }
    }

    public static Character evaluateChar(List list, Environment environment) {
        return Char.stringToCharacter((String)list.car());
    }

    public static Double evaluateDouble(List list, Environment environment) {
        try {
            return new Double((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateDouble: warning -- " + numberFormatException);
            return new Double(0.0);
        }
    }

    public static Float evaluateFloat(List list, Environment environment) {
        try {
            return new Float((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateFloat: warning -- " + numberFormatException);
            return new Float(0.0f);
        }
    }

    public static Integer evaluateInt(List list, Environment environment) {
        try {
            return new Integer((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateInt: warning -- " + numberFormatException);
            return new Integer(0);
        }
    }

    public static Long evaluateLong(List list, Environment environment) {
        try {
            return new Long((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateLong: warning -- " + numberFormatException);
            return new Long(0L);
        }
    }

    public static Short evaluateShort(List list, Environment environment) {
        try {
            return new Short((String)list.car());
        }
        catch (NumberFormatException numberFormatException) {
            Evaluate._e_("evaluateShort: warning -- " + numberFormatException);
            return new Short(0);
        }
    }

    public static Number object2Number(Object object, Continuation continuation) throws EvaluateError {
        if (object instanceof PrimitiveData) {
            object = ((PrimitiveData)object).unwrapValue();
        }
        if (object == null) {
            String string = "object2Number: null arg";
            throw new EvaluateError(string, continuation.info());
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        } else if (!(object instanceof Number)) {
            String string = "object2Number: arg not Number -- " + object;
            throw new EvaluateError(string, continuation.info());
        }
        return (Number)object;
    }

    public static Boolean object2Boolean(Object object, Continuation continuation) throws EvaluateError {
        if (!(object instanceof PrimitiveData)) {
            String string = "object2Boolean: value not PrimitiveData: " + object;
            throw new EvaluateError(string, continuation.info());
        }
        object = ((PrimitiveData)object).unwrapValue();
        if (!(object instanceof Boolean)) {
            String string = "object2Boolean: value not Boolean: " + object;
            throw new EvaluateError(string, continuation.info());
        }
        return (Boolean)object;
    }

    private static void _e_(String string) {
        System.err.println(string);
    }
}

